/*-------------------------commandline.cpp------------------------------------------
 runs luckybackup in command line mode

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.
 developer 		: luckyb 
 last modified 		: 10 Dec 2009
===============================================================================================================================
===============================================================================================================================
*/

#include "luckybackupwindow.cpp"
#include "commandline.h"

// class commandline Constructor=================================================================================================
commandline::commandline()
{
	writeToLog=FALSE;
	errorsFound = 0;
}

// class commandline Destructor=================================================================================================
commandline::~commandline()
{
}

// result===================================================================================================================
// calls functions intro, loadProfile, check_list, check_dirs, rsyncIT, thats_all and returns an integer to main()
int commandline::result()
{
	intro();
	
	rsyncIT();
	thats_all();

	if (errorsFound > 0)
		return 6;		// error at rsync or pre/post command execution

	return 0;
}

// intro===================================================================================================================
// displays an intro message
void commandline::intro()
{
	cout << "\n============================================================================================\n";
	cout << "		luckybackup version ";
	cout << appVersion;
	cout << " - command line mode \n";
	cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";
	cout << "This application will (hopefully) sync and backup everything you need in no time\n";
	cout << "(Well, it might take a little longer if run for the first time ;-)\n\n";
	cout << "\n";
	if (!NoQuestions)	//if questions are required
	{
		cout <<  "Make sure that:\n";
		cout <<  "You have already declared and mounted all the directories that need to be synced/backed-up\n";
		cout <<  "Please take a moment to examine all messages from checks done until now\n\n";
		cout <<  "Also have in mind that, to avoid errors, it is best to run this app as su\n\n";
		cout <<  "Hit 'enter' to continue otherwise press 'ctrl+c' to exit NOW\n";
		cin.get();
	}
	cout << "\n\n";
}



// rsyncIT===================================================================================================================
// Performs the execution of operations
void commandline::rsyncIT()
{
	cout << "\n============================================================================================\n";
	cout << "				Executing tasks";
	if (DryRun)
		cout << "  (simulation mode)";
	cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n";

	//some useful variables-----------------------------------------------------------------------
	QProcess *syncProcess;	syncProcess = new QProcess;	//create a new qprocess (for rsync)
	QString command="rsync";	//command to be executed. Normally this is "rsync"
	QStringList rsyncArguments;	// This stringList holds all arguments for the rsync command
	QString dirA;			//holds the first dir to be synced
	QString dirB;			//holds the second dir to be synced
	QString logText="";		//This text will be appended to the logfile
	
	currentOperation = 0;
	
	while (currentOperation < TotalOperations)
	{
		//if --skip-critical is given as argument and the task is CRITICAL
		if ( (Operation[currentOperation] -> GetCRITICAL()) && (SkipCritical) )	
			Operation[currentOperation] -> SetPerform(FALSE);	//don't perform this operation

		if ( (Operation[currentOperation] -> GetPerform()) || (Operation[currentOperation] -> GetByPassWARNING()) )
		{
			//update the last execution time
			if (!DryRun)
			{
				// logfile actions --------------------
				
				//first remove the older logfiles THIS WILL BE TAKEN OUT WHEN SNAPSHOTS ARE INTRODUCED
				logfilename = logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-" +
					(( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyyMMddhhmmss")) + ".log";
				logfile.setFileName(logfilename); // this is the old logfile
				logfile.remove();
				
				Operation[currentOperation] -> SetLastExecutionTime (QDateTime::currentDateTime());
				logfilename = logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-" +
					(( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyyMMddhhmmss")) + ".log";
				logfile.setFileName(logfilename); // this is the current logfile
				if (logfile.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Append))	//create a new log file
				{
					writeToLog = TRUE;
					syncProcess -> setStandardOutputFile(logfilename, QIODevice::Append );
					syncProcess -> setStandardErrorFile(logfilename, QIODevice::Append );
				}
				else
					writeToLog = FALSE;
			}
			
			//pre-task commands execution
			count = 0;
			while (Operation[currentOperation] -> GetExecuteBeforeListSize() > count)
			{
				cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
				cout << " Now executing pre-task command:  "
					<< Operation[currentOperation] -> GetExecuteBeforeListItem(count).toStdString() << "\n";
				
				logFileUpdate("pre-starting","",count);	//update the logfile

				//syncProcess -> execute (Operation[currentOperation] -> GetExecuteBeforeListItem(count));
				syncProcess -> start (Operation[currentOperation] -> GetExecuteBeforeListItem(count));
				syncProcess -> waitForStarted ();
				syncProcess -> waitForFinished ();
				cout << "\nexit code	: " << syncProcess -> exitCode();
				cout << "\nexit status	: " << syncProcess -> exitStatus() << "\n";
				if (syncProcess -> exitCode() != 0)
					errorsFound++;

				logFileUpdate("pre-finished", "", count);
				count++;
			}

			//task execution
			cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
			cout << " Now executing :  " << (Operation[currentOperation] -> GetName()).toStdString();
			cout << "\n--------------------------------------------------------------------------------------------\n";
			
			if (Operation[currentOperation] -> GetTypeSync())
				logFileUpdate("rsync-starting-syncAB", "", 0);
			else
				logFileUpdate("rsync-starting-backup", "", 0);
			
			rsyncArguments = AppendArguments(Operation[currentOperation]);	//set rsync arguments
			if (DryRun)
				rsyncArguments.insert(rsyncArguments.size()-2,"--dry-run");
			//if (writeToLog )
			//	rsyncArguments.insert(rsyncArguments.size()-2,"--log-file="+logfilename);

			//syncProcess -> execute (command,rsyncArguments);	// execute rsync command with rsyncArguments for backup or sync A->B
			syncProcess -> start (command,rsyncArguments);	
			syncProcess -> waitForStarted ();
			syncProcess -> waitForFinished ();
			cout << "\nrsync exit code		: " << syncProcess -> exitCode();
			cout << "\nrsync exit status	: " << syncProcess -> exitStatus() << "\n";
			if (syncProcess -> exitCode() != 0)
				errorsFound++;

			if (Operation[currentOperation] -> GetTypeSync())
				logFileUpdate("rsync-finished-sync1", "", 0);
			else
				logFileUpdate("rsync-finished", "", 0);
			
			if (Operation[currentOperation] -> GetTypeSync())	//execute rsync for syncing B -> A
			{
				logFileUpdate("rsync-starting-syncBA", "", 0);
				
				dirA = rsyncArguments[rsyncArguments.size()-2];	//swap last 2 arguments (dir names)
				dirB = rsyncArguments[rsyncArguments.size()-1];
				rsyncArguments.removeLast();	rsyncArguments.removeLast();
				rsyncArguments.append(dirB);
				rsyncArguments.append(dirA);

				//syncProcess -> execute (command,rsyncArguments);	// execute rsync command with rsyncArguments B->A
				syncProcess -> start (command,rsyncArguments);	
				syncProcess -> waitForStarted ();
				syncProcess -> waitForFinished ();
				cout << "\nrsync exit code		: " << syncProcess -> exitCode();
				cout << "\nrsync exit status	: " << syncProcess -> exitStatus() << "\n";
				if (syncProcess -> exitCode() != 0)
					errorsFound++;

				logFileUpdate("rsync-finished", "", 0);
			}

			//post-task commands execution
			count = 0;
			while (Operation[currentOperation] -> GetExecuteAfterListSize() > count)
			{
				cout << "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
				cout << " Now executing post-task command:  "
					<< Operation[currentOperation] -> GetExecuteAfterListItem(count).toStdString() << "\n";
					
				//update the logfile
				logFileUpdate("post-starting", "", count);
		
				//syncProcess -> execute (Operation[currentOperation] -> GetExecuteAfterListItem(count));

				syncProcess -> start (Operation[currentOperation] -> GetExecuteAfterListItem(count));
				syncProcess -> waitForStarted ();
				syncProcess -> waitForFinished ();
				cout << "\nexit code	: " << syncProcess -> exitCode();
				cout << "\nexit status	: " << syncProcess -> exitStatus() << "\n";
				if (syncProcess -> exitCode() != 0)
					errorsFound++;
				logFileUpdate("post-finished", "", count);
				
				count++;
			}
			// close the logfile
			if (writeToLog )
				logfile.close();
		}
		currentOperation++;
	}
}


// thats_all===================================================================================================================
// Displays an "all done" message
void commandline::thats_all()
{
	cout << "============================================================================================\n";
	cout << "			" << QDateTime::currentDateTime().toString(Qt::SystemLocaleLongDate).toStdString() << "\n";
	cout <<  "			Syncing and backing up is finished";
	if (DryRun)
		cout << "  (simulation mode)";
	if (errorsFound == 0)
		cout << "\n			No errors found";
	else
		cout << "\n			errors found: " << countStr.setNum(errorsFound).toStdString();
	if (writeToLog)
		cout << "\n 	logfile(s) have been created under directory: " << logDir.toStdString();
	cout <<  "\n\n			hope everything went ok ;-)\n";
	cout << "============================================================================================\n";
	
	saveProfile(currentProfile);	// updates the execution time
}

// end of commandline.cpp---------------------------------------------------------
 
