/* ---------------------------------- manage.cpp ---------------------------------------------------------------------------
 Class to display the manage backups dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 09 July 2009
===============================================================================================================================
===============================================================================================================================
*/
#include "manage.h"

// class manageDialog Constructor=================================================================================================
// Displays the manage backups of a task dialog
manageDialog::manageDialog (QDialog *parent) : QDialog (parent)
{

	//first set  variables source & dest
	QString source, dest;
	source = Operation[currentOperation] -> GetSource();
	dest = Operation[currentOperation] -> GetDestination();

	uiG.setupUi(this);
	uiG.treeView_source -> setVisible(FALSE);
	uiG.lineEdit_source -> setVisible(FALSE);
	//connect cancel pushButton SLOTs ----------------
	connect ( uiG.pushButton_cancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );

	QDirModel *model = new QDirModel;
	uiG.treeView_browser	-> setModel(model);
	uiG.treeView_browser	-> setRootIndex(model->index(source));
	uiG.treeView_source	-> setModel(model);
	uiG.treeView_source	-> setRootIndex(model->index(source));
	uiG.lineEdit_destination -> setText(dest);
	uiG.lineEdit_source	-> setText(source);
	//Operation[currentTask] -> GetDestination()
}
// SLOTS-------------------------------------------------------------------------------------
// --------------------------------cancel pressed------------------------------------------------
void manageDialog::cancel()
{
	close();
}

// FUNCTIONS-------------------------------------------------------------------------------------

// end of manage.cpp ---------------------------------------------------------------------------

