/* ------------------ luckybackupwindow.h --------------------------------------------------------------------------------------
 header file for luckyBackup project

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 22 April 2009
===============================================================================================================================
===============================================================================================================================
*/


#ifndef LUCKYBACKUPWINDOW_H
#define LUCKYBACKUPWINDOW_H

//include  header file that qmake produces from "*.ui" created with qt designer
#include "ui_luckybackupwindow.h"

//==============================================================================================================
//Declaration of luckyBackupWindow class (this is the main window of the app)
class luckyBackupWindow : public QMainWindow
{
	Q_OBJECT
	
	public:
		luckyBackupWindow (QMainWindow *parent = 0);

		// general variables
		bool taskClicked;	//these 2 bool vars help to determine when a checkbox state is changed for SLOT taskStateChanged
		bool taskChanged;
		bool savedProfile;	// Becomes true if a profile is saved and false if it is modified

		bool GoBack;		// Becomes true if the user tries to load a profile, but regrets it !!
		QString InfoData;	//String holding the information window text
		QString createData;	//String holding messages from createCurrentProfile
		QString loadData;	//String holding messages from loadCurrentProfile
		QString saveData;	//String holding messages from saveCurrentProfile

		int InfoInt;		// this helps to define which message will appear at the info window
		int count;		//simple count variable !!

	private slots:
		void profileComboChanged();	// SLOT to set the currentProfile when profileCombo index changes
		void savePressed();		// SLOT to execute when "save" pressed
		void deleteCurrentProfile();	//SLOT: Delete the current profile
		void NewProfile();		//SLOT: Create a new empty profile
		void setDefaultProfile();	//SLOT: Set the current profile as default
		void renameCurrentProfile();	//SLOT: rename the current profile
		void exportProfile();		//SLOT to export a profile
		void importProfile();		//SLOT to import a profile

		void exitApp();		//SLOT: check if a profile is saved and exit application

		void help();		//SLOT: open "help" popup when action selected
		void about();		//SLOT: open "about" popup when action selected
		void setToolbarAttrs();	//SLOT: sets the toolbar attributes

		void setLanguage(QAction *);	//SLOT: Change the application language

		void checkCurrentItem();	//SLOT: Check the currently selected operation and set an icon
		void taskStateChanged();	//SLOT: Sets the profile state to unsaved if a task checkbox is changed
		void refreshList();	//SLOT: Refresh the operations list when refresh button pressed
		void start();		//SLOT: Open start operations dialog when Button clicked()
		void modify();		//SLOT: Mosify an existing operation
		void add();		//SLOT: Add a new operation
		void remove();		//SLOT: remove highlighted operation
		void manage();		//SLOT: Manage existing backups of an existing operation
		void moveUp();		//SLOT: move  highlighted operation one position up
		void moveDown();	//SLOT: move  highlighted operation one position down
		void schedule();	//SLOT: Open schedule dialog when Button clicked()

	private:
		Ui::luckyBackupWindow ui;

		QMenu *languageMenu;
		QMenu *settingsMenu;
//		QMenu *toolbarMenu;
//		QMenu *toolbarStyleMenu;
//		QMenu *toolbarButtonsMenu;
		QActionGroup *languageGroup;
//		QActionGroup *toolbarStyleGroup;
//		QActionGroup *toolbarButtonsGroup;
		QMenu *helpMenu;
		QAction *action;
		QAction *actionHelp;
		QAction *actionAbout;
		QToolBar *profileToolbar;
		QToolBar *profileComboToolbar;
		QAction *visibleProfileToolbar;
		QAction *visibleProfileComboToolbar;
		QAction *actionLockToolbars;
		QAction *actionVisibleToolbarText;

		//The following functions are inside functions.cpp
		void AlsoCreateRestore();		//function to create another operation for RESTORE
		void setCurrentProfile(QString);	//function to check if a profile is valid and load it by calling loadProfile
		bool loadCurrentProfile();		//function to  load an existing profile
		bool saveCurrentProfile();		//function to save a profile 
		int createCurrentProfile();		//function to create a profile
		int isProfileSaved();			//function to check if the current profile is saved and proceed or not
		void checkDeclared();			//function to check all declared data of included operations
		bool checkOperationList();		// function to first check the operations list for errors (eg nothing is included)
		void retranslateUi();			//function to retranslate the ui when user changes the gui language
		void createMenus();			// create the menu "language" with all available languages & menu "help"
		void createToolbar();			// create the toolbar
		void createActions();			// create all actions
		void createProfileCombo();		// fill the profile combo box with existing profile names
		bool saveSettings();			//saves various luckybackup settings such as the default profile
		bool loadSettings();			//loads various luckybackup settings such as the default profile
		void InitializeVariables();		//initializes all variables

		QString defaultLanguage;		// holds the app's default language
		QString TransDir;			// holds the actual translation directory path
		QUrl helpURL;				// holds the actual manual path as a QUrl
		QUrl licenseURL;			// holds the actual license path as a QUrl
		int mainWindowWidth;			// holds the main window width in pixels
		int mainWindowHeight;			// holds the main window height in pixels
		bool AreToolbarsLocked;			// holds the lock state of the toolbars
		bool IsVisibleProfileComboToolbar;	// holds the visible state of the profile combo toolbar
		bool IsVisibleProfileToolbar;		// holds the visible state of the profile toolbar
		bool IsVisibleToolbarText;		// holds the visible state of the toolbar text

	protected:
		void closeEvent(QCloseEvent *event);
};

#endif

// end of luckybackupwindow.h--------------------------------------------------------------
