/*-------------------------commandline.h------------------------------------------
	header file for commandline.cpp

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 25 January 2009
===============================================================================================================================
===============================================================================================================================

 runs luckybackup in command line mode
*/

#ifndef COMMANDLINE_H
#define COMMANDLINE_H

#include <iostream>

using namespace std;

//==============================================================================================================
//Declaration of commandline class (this is the class that runs luckybackup in command line mode)
class commandline
{
	public:
		commandline ();
		~commandline();

		void rsyncIT();		//perform rsync execution
		void thats_all();	//display a "finished" message
		void help();		//displays a help message
		int result();		//executes all necessary function & returns an integer
		bool argsTest(int, char**);	//returns true if the umber of arguments is valid (2)

		bool console;		//these become true depending on the argument given at command line
		bool NoQuestions;
		bool SkipCritical;
		bool DryRun;
		int count;		//simple count variable !!
		QString CheckedData;	//String holding the ok - notOK message after the backup dirs check
		bool writeToLog;	//if the log file is ok to write this becomes TRUE

	private:
		char* profileName;
		void intro();		//display an intro message
		bool loadCurrentProfile();	//loads an already created profile
		bool check_list();	//check the operations list
		bool check_dirs();	//check directories of declared profile data
};

#endif
// end of commandline.h---------------------------------------------------------
 
