#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Mode: Python -*-
# vi:si:ai:et:sw=4:sts=4:ts=4
#
# Copyright Nicolas Bertrand (nico@inattendu.org), 2009
#
# This file is part of Luciole.
#
#    Luciole is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Luciole is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Luciole.  If not, see <http://www.gnu.org/licenses/>.
#
#
import pygst
pygst.require('0.10')
import gst
import gst.interfaces


class luciole_gstreamer_sound(object) :
	"""  gstreamer  : play a sound  """

	def __init__(self,soundfile,cb_error = None) :
		"""
		soundfile : The soundfile to play
		cb_error : callback arror function
		"""
    
		self._soundfile = soundfile
		self._cb_error = cb_error
		# 
		# Creation of gstreamer pipeline
		#
		self.pipe = gst.Pipeline()

		# Create elements
		self.src = gst.element_factory_make('filesrc')
		self.src.set_property('location', self._soundfile)
		
		self.dec = gst.element_factory_make('decodebin')
		# Connect handler for 'new-decoded-pad' signal 
		self.dec.connect('new-decoded-pad', self.on_new_decoded_pad)

		self.conv = gst.element_factory_make('audioconvert')
		self.rsmpl = gst.element_factory_make('audioresample')
		self.sink = gst.element_factory_make('alsasink')

		#
		# Add elements to pipeline
		#
		self.pipe.add(self.src, self.dec, self.conv, self.rsmpl, self.sink)
   
		# Linkelements 
		self.src.link(self.dec)
		gst.element_link_many(self.conv, self.rsmpl, self.sink)
    
		
		# Reference used in self.on_new_decoded_pad()
		self.apad = self.conv.get_pad('sink')
		
		self._on_error = False
   
		# connect bus
		bus = self.pipe.get_bus()
		bus.enable_sync_message_emission()
		bus.add_signal_watch()
		bus.connect('sync-message::element', self.on_sync_message)
		bus.connect('message', self.on_message)
		self.pipe.set_state(gst.STATE_NULL)

	def on_new_decoded_pad(self, element, pad, last):
		caps = pad.get_caps()
		name = caps[0].get_name()
		if name == 'audio/x-raw-float' or name == 'audio/x-raw-int':
			if not self.apad.is_linked(): # Only link once
				pad.link(self.apad)
	    
    
	def on_sync_message(self, bus, message):
		""" sync message callback  """
		if message.structure is None:
			return
    
	def on_message(self, bus, message):
		t = message.type
        if t == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            print "Error: %s" % err, debug
            self.playing = False
			self._on_error = True 
			
			if self._cb_error != None : self.cb_error()
        elif t == gst.MESSAGE_EOS:
            self.playing = False           
			self.pipe.set_state(gst.STATE_NULL)
  
    def pause(self):
        gst.info("pausing player")
        self.pipe.set_state(gst.STATE_PAUSED)
        self.playing = False

    def play(self):
		if self._on_error != True : 
			gst.info("playing player")
			self.pipe.set_state(gst.STATE_PLAYING)
			self.playing = True
        
    def stop(self):
        self.pipe.set_state(gst.STATE_NULL)
        gst.info("stopped player")

    def get_state(self, timeout=1):
        return self.pipe.get_state(timeout=timeout)

    def is_playing(self):
        return self.playing
  

