<?php
/*
# Copyright 2006, CRIM, Stephane Bond
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/


require_once 'dbFunctions.php';
class HWGroupRule {

	var $node_id;
	var $hwkey;
	var $hwvalue;
	var $operator;
	var $isError;
	var $notFound;
	var $lastError;

	function HWGroupRule($nodeId,$hwkey=NULL,$hwvalue=NULL,$operator=NULL) {
		$this->isError = false;
		$this->noFound = false;

		if (is_numeric($nodeId)) {
			$this->node_id = $nodeId;
			if(isset($hwkey))$this->hwkey = $hwkey;
			if(isset($hwvalue))$this->hwvalue = $hwvalue;
			if(isset($operator))$this->operator = trim($operator);
		}
		else if (is_array($nodeId)) {
			$cols = $nodeId;
			$this->node_id = $cols['nodes_id'];
			$this->hwkey = $cols['hwkey'];
			$this->hwvalue = $cols['hwvalue'];
			$this->operator = trim($cols['operator']);
		}
		else {
			$this->isError = true;
			$this->lastError = getMessage('bad_id')."node_id=".$nodeId;
			return;
		}
	}

	// private
	function updateDB($toSet,$table="hwgroupsrule", $where = "id") {
		if ($where == "id") $where = "nodes_id=".$this->node_id." AND hwkey=".qstr($this->hwkey)." AND hwvalue=".qstr($this->hwvalue);
		$query = "UPDATE ".$table." SET ".$toSet." WHERE ".$where;
		if ($error = write($query)) {
			$this->lastError = getMessage('db_write_error').$error." : ".$query;
			return false;
		}
		else return true;
	}

	/*
	 * Return true if the hardware list match the rule
	 * 
	 * (PDubois)Patrick Dubois - Modifications - July 10, 2008
	 *    Bugfix - Added null array check to fix configuration panel 
	 *    error.  When viewing a node without hardware (ie: categories or groups)
	 *    PHP would report an invalid argument error for 'foreach' below.
	 */
	function match($hwList) {
		if ( ! is_null($hwList) ) {
			$match=false;
			foreach ($hwList as $hw) {
				if ($hw["hwkey"] == $this->hwkey && $match==false) {
					if ($this->hwvalue == '' || $this->hwvalue == '*')
					$match=true;
					else if ($this->operator == '=' || $this->operator == '==' || $this->operator == '!=')
						$match=($hw["hwvalue"] == $this->hwvalue);
					else if ($this->operator == '>')
						$match=($hw["hwvalue"] > $this->hwvalue);
					else if ($this->operator == '>=')
						$match=($hw["hwvalue"] >= $this->hwvalue);
					else if ($this->operator == '<')
						$match=($hw["hwvalue"] < $this->hwvalue);
					else if ($this->operator == '<=')
						$match=($hw["hwvalue"] <= $this->hwvalue);
					else if ($this->operator == 'in')
						$match=(strpos($hw["hwvalue"],$this->hwvalue)>=0);
				}
			}
			if ($this->operator == '!=')
				$match=!$match;
			return $match;
		}// end if 
		else {
			$match=false;
			return $match;
		     }
	}

	/**
	 * Update hwg list
	 */
	 function updateList($list){
	 	startTrans();
	 	$this->deleteAll();
	 	foreach($list as $hwGroup){
	 		$hwGroup->insertDB();
	 	}
	 	completeTrans();
	 }

	//////////////////////////////////////////////////////////////////
	// Getters
	//////////////////////////////////////////////////////////////////

	function getNodeID() {
		return $this->node_id;
	}

	function getHwKey() {
		return $this->hwkey;
	}

	function getHwValue() {
		return $this->hwvalue;
	}

	function getOperator() {
		return $this->operator;
	}

	function isError() {
		return $this->isError;
	}

	function lastError() {
		return $this->lastError;
	}

	function notFound() {
		return $this->NotFound;
	}

	//////////////////////////////////////////////////////////////////
	// Setters
	//////////////////////////////////////////////////////////////////

	function delete() {
		$error = NULL;
		$error .= delete("DELETE FROM hwgroupsrule WHERE nodes_id=".$this->node_id." AND hwkey=".qstr($this->hwkey)." AND hwvalue=".qstr($this->hwvalue));
		return $error;
	}
	function deleteAll() {
		if($error = delete("DELETE FROM hwgroupsrule WHERE nodes_id=".$this->node_id)){
			$this->lastError = $error;
			$this->isError=true;
			return false;
		}else{
			return true;
		}
	}

	function setValue($newHwkey, $newHwvalue, $newOperator) {
		if ($this->isError) return false;
		if (!$this->updateDB("hwkey=".qstr($newHwkey).",hwvalue=".qstr($newHwkey).",operator=".$newOperator)) return false;
		$this->hwkey = $newHwkey;
		$this->hwvalue = $newHwvalue;
		$this->operator = $newOperator;
		return true;
	}
	function insertDB() {
		$values = $this->node_id.",".qstr($this->hwkey).",".qstr($this->hwvalue).",".qstr($this->operator);
		$query = "INSERT INTO hwgroupsrule(nodes_id,hwkey,hwvalue,operator) VALUES(".$values.")";
		if ($error = write($query)) {
			$this->lastError = getMessage('db_write_error').$error." : ".$query;
			$this->isError=true;
			return false;
		}
		else return true;
	}
	function getOperators(){
		$opList = array("=","!=",">",">=","<","<=","in");
		return $opList;
	}
}
?>
