/*
   b_ptr_timespec.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Friday, December 17 at 06:05 PM CST

TITLE
   b_ptr_timespec.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_ptr_timespec.h"

//--------------------------------------------------------------------


 static struct timespec timeout_tmp;
//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_ptr_timespecTYPENAME,CLASS_STRING);
strcpy(_b_ptr_timespecREALTIME,"b_ptr_timespec_REALTIME");
strcpy(_b_ptr_timespecTIMEOUT_ZERO,"b_ptr_timespec_TIMEOUT_ZERO");
strcpy(_b_ptr_timespecTIMEOUT_NEG_ONE_NS,"b_ptr_timespec_TIMEOUT_NEG_ONE_NS");
strcpy(_b_ptr_timespecTIMEOUT_ILL,"b_ptr_timespec_TIMEOUT_ILL");
strcpy(_b_ptr_timespecTIMEOUT_NEG_ONE_SEC,"b_ptr_timespec_TIMEOUT_NEG_ONE_SEC");
strcpy(_b_ptr_timespecTIMEOUT_MIN,"b_ptr_timespec_TIMEOUT_MIN");
strcpy(_b_ptr_timespecTIMEOUT_MAX,"b_ptr_timespec_TIMEOUT_MAX");
strcpy(_b_ptr_timespecTIMEOUT_MIXED_1,"b_ptr_timespec_TIMEOUT_MIXED_1");
strcpy(_b_ptr_timespecTIMEOUT_MIXED_2,"b_ptr_timespec_TIMEOUT_MIXED_2");
}

//--------------------------------------------------------------------
b_param *b_ptr_timespec::b_ptr_timespecREALTIME()
{
   return &_b_ptr_timespecREALTIME;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_ZERO()
{
   return &_b_ptr_timespecTIMEOUT_ZERO;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_NEG_ONE_NS()
{
   return &_b_ptr_timespecTIMEOUT_NEG_ONE_NS;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_ILL()
{
   return &_b_ptr_timespecTIMEOUT_ILL;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_NEG_ONE_SEC()
{
   return &_b_ptr_timespecTIMEOUT_NEG_ONE_SEC;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_MIN()
{
   return &_b_ptr_timespecTIMEOUT_MIN;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_MAX()
{
   return &_b_ptr_timespecTIMEOUT_MAX;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_MIXED_1()
{
   return &_b_ptr_timespecTIMEOUT_MIXED_1;
}

b_param *b_ptr_timespec::b_ptr_timespecTIMEOUT_MIXED_2()
{
   return &_b_ptr_timespecTIMEOUT_MIXED_2;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_ptr_timespecTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_ptr_timespec_realtime = 0;
b_ptr_timespec_timeout_zero = 0;
b_ptr_timespec_timeout_neg_one_ns = 0;
b_ptr_timespec_timeout_ill = 0;
b_ptr_timespec_timeout_neg_one_sec = 0;
b_ptr_timespec_timeout_min = 0;
b_ptr_timespec_timeout_max = 0;
b_ptr_timespec_timeout_mixed_1 = 0;
b_ptr_timespec_timeout_mixed_2 = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_timespecREALTIME)==0)
      b_ptr_timespec_realtime = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_ZERO)==0)
      b_ptr_timespec_timeout_zero = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_NEG_ONE_NS)==0)
      b_ptr_timespec_timeout_neg_one_ns = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_ILL)==0)
      b_ptr_timespec_timeout_ill = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_NEG_ONE_SEC)==0)
      b_ptr_timespec_timeout_neg_one_sec = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_MIN)==0)
      b_ptr_timespec_timeout_min = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_MAX)==0)
      b_ptr_timespec_timeout_max = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_MIXED_1)==0)
      b_ptr_timespec_timeout_mixed_1 = 1;
   else if (strcmp(data[dataPTR],_b_ptr_timespecTIMEOUT_MIXED_2)==0)
      b_ptr_timespec_timeout_mixed_2 = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"HVAL"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

if (b_ptr_timespec_realtime==1)
{

 if (clock_gettime(CLOCK_REALTIME, &timeout_tmp) == -1)
 {
 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }
 fprintf(logFile, "b_ptr_timespec REALTIME - error encountered getting timespec for REALTIME - function not tested\n");
 fclose(logFile);
 exit(99);
 }
 
}

if (b_ptr_timespec_timeout_zero==1)
{

 timeout_tmp.tv_sec = 0;
 timeout_tmp.tv_nsec = 0;
 
}

if (b_ptr_timespec_timeout_neg_one_ns==1)
{

 timeout_tmp.tv_sec = 0;
 timeout_tmp.tv_nsec = -1;
 
}

if (b_ptr_timespec_timeout_ill==1)
{

 timeout_tmp.tv_sec = 0;
 timeout_tmp.tv_nsec = (int) 10e10;
 
}

if (b_ptr_timespec_timeout_neg_one_sec==1)
{

 timeout_tmp.tv_sec = -1;
 timeout_tmp.tv_nsec = 0;
 
}

if (b_ptr_timespec_timeout_min==1)
{

 timeout_tmp.tv_sec = -MAXLONG; 
 timeout_tmp.tv_nsec = -MAXINT;
 
}

if (b_ptr_timespec_timeout_max==1)
{

 timeout_tmp.tv_sec = MAXLONG;
 timeout_tmp.tv_nsec = MAXINT;
 
}

if (b_ptr_timespec_timeout_mixed_1==1)
{

 timeout_tmp.tv_sec = -1;
 timeout_tmp.tv_nsec = 1;
 
}

if (b_ptr_timespec_timeout_mixed_2==1)
{

 timeout_tmp.tv_sec = 1; 
 timeout_tmp.tv_nsec = -1; 
 
}

 _theVariable=&timeout_tmp;
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 9;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_ptr_timespecREALTIME();
         break;
      case 2:
         return b_ptr_timespecTIMEOUT_ZERO();
         break;
      case 3:
         return b_ptr_timespecTIMEOUT_NEG_ONE_NS();
         break;
      case 4:
         return b_ptr_timespecTIMEOUT_ILL();
         break;
      case 5:
         return b_ptr_timespecTIMEOUT_NEG_ONE_SEC();
         break;
      case 6:
         return b_ptr_timespecTIMEOUT_MIN();
         break;
      case 7:
         return b_ptr_timespecTIMEOUT_MAX();
         break;
      case 8:
         return b_ptr_timespecTIMEOUT_MIXED_1();
         break;
      case 9:
         return b_ptr_timespecTIMEOUT_MIXED_2();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
