/*
   b_fd.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Friday, December 17 at 05:53 PM CST

TITLE
   b_fd.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_fd.h"

//--------------------------------------------------------------------


#define TESTDIR "testdir"
#define TESTFILE "testdir/testfile_fp"
//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_fdTYPENAME,CLASS_STRING);
strcpy(_b_fdREAD,"b_fd_READ");
strcpy(_b_fdWRITE,"b_fd_WRITE");
strcpy(_b_fdAPPEND,"b_fd_APPEND");
strcpy(_b_fdREAD_PLUS,"b_fd_READ_PLUS");
strcpy(_b_fdWRITE_PLUS,"b_fd_WRITE_PLUS");
strcpy(_b_fdAPPEND_PLUS,"b_fd_APPEND_PLUS");
strcpy(_b_fdR_USER,"b_fd_R_USER");
strcpy(_b_fdW_USER,"b_fd_W_USER");
strcpy(_b_fdX_USER,"b_fd_X_USER");
strcpy(_b_fdRWX_USER,"b_fd_RWX_USER");
strcpy(_b_fdR_GRP,"b_fd_R_GRP");
strcpy(_b_fdNONE,"b_fd_NONE");
strcpy(_b_fdEXIST,"b_fd_EXIST");
strcpy(_b_fdCLOSED,"b_fd_CLOSED");
strcpy(_b_fdDELETED,"b_fd_DELETED");
strcpy(_b_fdNO_EXIST,"b_fd_NO_EXIST");
strcpy(_b_fdEMPTY,"b_fd_EMPTY");
strcpy(_b_fdBEGINNING,"b_fd_BEGINNING");
strcpy(_b_fdEOF,"b_fd_EOF");
strcpy(_b_fdPAST_EOF,"b_fd_PAST_EOF");
}

//--------------------------------------------------------------------
b_param *b_fd::b_fdREAD()
{
   return &_b_fdREAD;
}

b_param *b_fd::b_fdWRITE()
{
   return &_b_fdWRITE;
}

b_param *b_fd::b_fdAPPEND()
{
   return &_b_fdAPPEND;
}

b_param *b_fd::b_fdREAD_PLUS()
{
   return &_b_fdREAD_PLUS;
}

b_param *b_fd::b_fdWRITE_PLUS()
{
   return &_b_fdWRITE_PLUS;
}

b_param *b_fd::b_fdAPPEND_PLUS()
{
   return &_b_fdAPPEND_PLUS;
}

b_param *b_fd::b_fdR_USER()
{
   return &_b_fdR_USER;
}

b_param *b_fd::b_fdW_USER()
{
   return &_b_fdW_USER;
}

b_param *b_fd::b_fdX_USER()
{
   return &_b_fdX_USER;
}

b_param *b_fd::b_fdRWX_USER()
{
   return &_b_fdRWX_USER;
}

b_param *b_fd::b_fdR_GRP()
{
   return &_b_fdR_GRP;
}

b_param *b_fd::b_fdNONE()
{
   return &_b_fdNONE;
}

b_param *b_fd::b_fdEXIST()
{
   return &_b_fdEXIST;
}

b_param *b_fd::b_fdCLOSED()
{
   return &_b_fdCLOSED;
}

b_param *b_fd::b_fdDELETED()
{
   return &_b_fdDELETED;
}

b_param *b_fd::b_fdNO_EXIST()
{
   return &_b_fdNO_EXIST;
}

b_param *b_fd::b_fdEMPTY()
{
   return &_b_fdEMPTY;
}

b_param *b_fd::b_fdBEGINNING()
{
   return &_b_fdBEGINNING;
}

b_param *b_fd::b_fdEOF()
{
   return &_b_fdEOF;
}

b_param *b_fd::b_fdPAST_EOF()
{
   return &_b_fdPAST_EOF;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_fdTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_fd_read = 0;
b_fd_write = 0;
b_fd_append = 0;
b_fd_read_plus = 0;
b_fd_write_plus = 0;
b_fd_append_plus = 0;
b_fd_r_user = 0;
b_fd_w_user = 0;
b_fd_x_user = 0;
b_fd_rwx_user = 0;
b_fd_r_grp = 0;
b_fd_none = 0;
b_fd_exist = 0;
b_fd_closed = 0;
b_fd_deleted = 0;
b_fd_no_exist = 0;
b_fd_empty = 0;
b_fd_beginning = 0;
b_fd_eof = 0;
b_fd_past_eof = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_fdREAD)==0)
      b_fd_read = 1;
   else if (strcmp(data[dataPTR],_b_fdWRITE)==0)
      b_fd_write = 1;
   else if (strcmp(data[dataPTR],_b_fdAPPEND)==0)
      b_fd_append = 1;
   else if (strcmp(data[dataPTR],_b_fdREAD_PLUS)==0)
      b_fd_read_plus = 1;
   else if (strcmp(data[dataPTR],_b_fdWRITE_PLUS)==0)
      b_fd_write_plus = 1;
   else if (strcmp(data[dataPTR],_b_fdAPPEND_PLUS)==0)
      b_fd_append_plus = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"MODE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_fdR_USER)==0)
      b_fd_r_user = 1;
   else if (strcmp(data[dataPTR],_b_fdW_USER)==0)
      b_fd_w_user = 1;
   else if (strcmp(data[dataPTR],_b_fdX_USER)==0)
      b_fd_x_user = 1;
   else if (strcmp(data[dataPTR],_b_fdRWX_USER)==0)
      b_fd_rwx_user = 1;
   else if (strcmp(data[dataPTR],_b_fdR_GRP)==0)
      b_fd_r_grp = 1;
   else if (strcmp(data[dataPTR],_b_fdNONE)==0)
      b_fd_none = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"PERMISSIONS"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_fdEXIST)==0)
      b_fd_exist = 1;
   else if (strcmp(data[dataPTR],_b_fdCLOSED)==0)
      b_fd_closed = 1;
   else if (strcmp(data[dataPTR],_b_fdDELETED)==0)
      b_fd_deleted = 1;
   else if (strcmp(data[dataPTR],_b_fdNO_EXIST)==0)
      b_fd_no_exist = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"EXISTANCE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_fdEMPTY)==0)
      b_fd_empty = 1;
   else if (strcmp(data[dataPTR],_b_fdBEGINNING)==0)
      b_fd_beginning = 1;
   else if (strcmp(data[dataPTR],_b_fdEOF)==0)
      b_fd_eof = 1;
   else if (strcmp(data[dataPTR],_b_fdPAST_EOF)==0)
      b_fd_past_eof = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"STATE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

 mode_t permissionMode;
 int oflag;
 int exist_flag = 1;
 int pos;
 int empty_flag = 0;

 struct stat stat_buf_temp;
 int fd;

 

 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }
 

 if (mkdir(TESTDIR,S_IRWXU|S_IRWXG|S_IRWXO)!=0) /* create test directory, u+rwx */ 
 { 
 
 if (errno != EEXIST) 
 {
 fprintf(logFile,"mkdir failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 }
 
 if (unlink (TESTFILE) != 0 )
 {
 if (errno != ENOENT) 
 {
 fprintf(logFile,"unlink failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 }

 if((fd = open (TESTFILE, O_WRONLY | O_CREAT | O_TRUNC, 0644))==-1)
 {
 fprintf(logFile,"b_fd datatype not setup properly - open failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }

if (b_fd_empty==1)
{

 empty_flag = 1;
 
}

if (b_fd_read==1 || b_fd_read_plus==1 || b_fd_append==1 || b_fd_append_plus==1)
{
 
 if (! empty_flag)
 {
 write (fd, "I am a test file.\n", 18);
 }
 
}
 
 if (close (fd)!=0) 
 {
 fprintf(logFile,"b_fd datatype not setup properly - close failed. Function not tested\n");
 fclose(logFile);
 exit(99); 
 }

if (b_fd_no_exist==1)
{

 exist_flag = 0;
 remove(TESTFILE);
 
}

if (b_fd_read==1)
{

 oflag = O_RDONLY; 
 
}

if (b_fd_write==1)
{

 if (exist_flag)
 {
 oflag = O_WRONLY | O_CREAT | O_TRUNC;
 }
 else 
 {
 oflag = O_WRONLY | O_TRUNC;
 }
 
}

if (b_fd_append==1)
{

 if (exist_flag)
 {
 oflag = O_WRONLY | O_CREAT | O_APPEND;
 }
 else 
 {
 oflag = O_WRONLY | O_APPEND;
 } 
 
}

if (b_fd_read_plus==1)
{

 oflag = O_RDWR; 
 
}

if (b_fd_write_plus==1)
{

 if (exist_flag)
 {
 oflag = O_RDWR | O_CREAT | O_TRUNC;
 } 
 else 
 { 
 oflag = O_RDWR | O_TRUNC;
 }
 
}

if (b_fd_append_plus==1)
{

 if (exist_flag)
 { 
 oflag = O_RDWR | O_CREAT | O_APPEND;
 } 
 else 
 {
 oflag = O_RDWR | O_APPEND;
 } 
 
}

if (b_fd_r_user==1)
{

 permissionMode = S_IRUSR;
 
}

if (b_fd_w_user==1)
{

 permissionMode = S_IWUSR;
 
}

if (b_fd_x_user==1)
{

 permissionMode = S_IXUSR;
 
}

if (b_fd_rwx_user==1)
{

 permissionMode = S_IRWXU;
 
}

if (b_fd_r_grp==1)
{

 permissionMode = S_IRGRP;
 
}

if (b_fd_none==1)
{

 permissionMode = 0;
 
}

 if ((fd = open(TESTFILE, oflag, permissionMode)) == -1)
 {
 if (exist_flag)
 {
 fprintf(logFile,"b_fd datatype not setup properly - open failed\n");
 fclose(logFile);
 exit (99);
 }
 }

if (b_fd_write==1 || b_fd_write_plus==1)
{

 if (! empty_flag)
 {
 write (fd, "I am a test file.\n", 18);
 }
 
}

if (b_fd_beginning==1)
{

 if (exist_flag && ((pos = lseek(fd, 0L, SEEK_SET)) == -1L))
 {
 fprintf(logFile,"b_fd datatype not setup properly - lseek SET failed\n");
 fclose(logFile);
 exit (99); 
 }
 
}

if (b_fd_eof==1)
{

 if (exist_flag && ((pos = lseek(fd, 0L, SEEK_END)) == -1L))
 {
 fprintf(logFile,"b_fd datatype not setup properly - lseek END failed\n");
 fclose(logFile);
 exit (99);
 }
 
}

if (b_fd_past_eof==1)
{

 if (exist_flag && ((pos = lseek(fd, 10L, SEEK_END)) == -1L))
 {
 fprintf(logFile,"b_fd datatype not setup properly - lseek END failed\n");
 fclose(logFile);
 exit (99);
 }
 
}
 
 _theVariable = fd;
 fclose (logFile);
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated

 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }
 
 int exist_flag = 1;

if (b_fd_no_exist==1)
{

 exist_flag = 0;
 
}

if (b_fd_closed==1)
{

 if (exist_flag)
 {
 close(_theVariable);
 }
 
}

if (b_fd_deleted==1)
{

 if (exist_flag)
 {
 
 char buffer[128];
 if ((sprintf(buffer, "rm %s", TESTFILE)) <= 0)
 {
 fprintf(logFile,"b_fd datatype not setup properly - rm of the TESTFILE failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 system(buffer);
 
 }
 
}

 fclose(logFile);
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated
 
 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }

if (b_fd_closed==1 || b_fd_exist==1)
{

 chown(TESTFILE, getuid(), getgid()); 
 chmod(TESTFILE, S_IRUSR|S_IWUSR|S_IROTH|S_IWOTH);
 if (close (_theVariable)!=0) 
 { 
 if (errno != EBADF) perror("close fname_tempfd");
 }
 
}

 if (unlink(TESTFILE)!=0)
 {
 
 if (errno != ENOENT) 
 {
 fprintf(logFile,"unlink fname_testfilename\n");
 }
 }

 
 rmdir(TESTFILE);
 fclose(logFile);
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 6;
      break;

   case 2:
      return 6;
      break;

   case 3:
      return 4;
      break;

   case 4:
      return 4;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_fdREAD();
         break;
      case 2:
         return b_fdWRITE();
         break;
      case 3:
         return b_fdAPPEND();
         break;
      case 4:
         return b_fdREAD_PLUS();
         break;
      case 5:
         return b_fdWRITE_PLUS();
         break;
      case 6:
         return b_fdAPPEND_PLUS();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 2:
 switch (position)
   {
      case 1:
         return b_fdR_USER();
         break;
      case 2:
         return b_fdW_USER();
         break;
      case 3:
         return b_fdX_USER();
         break;
      case 4:
         return b_fdRWX_USER();
         break;
      case 5:
         return b_fdR_GRP();
         break;
      case 6:
         return b_fdNONE();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 3:
 switch (position)
   {
      case 1:
         return b_fdEXIST();
         break;
      case 2:
         return b_fdCLOSED();
         break;
      case 3:
         return b_fdDELETED();
         break;
      case 4:
         return b_fdNO_EXIST();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 4:
 switch (position)
   {
      case 1:
         return b_fdEMPTY();
         break;
      case 2:
         return b_fdBEGINNING();
         break;
      case 3:
         return b_fdEOF();
         break;
      case 4:
         return b_fdPAST_EOF();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
