'''
Defines an initial configuration that has two profiles, user and developer, 
containing the appropriate UIEs that ship with LSR.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

# UIEs to install that ship with LSR
class install:
  device = ['Keyboard', 'CliqueAudio', 'IBMSpeech', 'FestivalSpeech']
  perk = ['DefaultPerk', 'AltShiftPerk', 'MetacityPerk', 'GaimPerk', 
           'GTerminalPerk', 'DeveloperPerk']
  monitor = ['RawEventMonitor','TaskMonitor']
  chooser = []
  
# classes representing initial profile configuration
class user:
  name = 'user'
  device = ['Keyboard', 'CliqueAudio', 'IBMSpeech', 'FestivalSpeech']
  monitor = []
  chooser = []
  perk = {None : ['DefaultPerk', 'AltShiftPerk'],
           'metacity' : ['MetacityPerk'],
           'gaim' : ['GaimPerk'],
           'gnome-terminal' : ['GTerminalPerk']
          }
            
class developer(user):
  name = 'developer'
  monitor = ['RawEventMonitor','TaskMonitor']
  perk = {None : ['DefaultPerk', 'AltShiftPerk', 'DeveloperPerk'],
           'metacity' : ['MetacityPerk'],
           'gaim' : ['GaimPerk'],
           'gnome-terminal' : ['GTerminalPerk']
          }

# list of all profiles to create
profiles = [user, developer]