'''
Defines the abstract base class for all L{AEMonitor} subclasses that will
monitor internal LSR events such as L{AEEvent}s and L{Task}s.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Base

class EventMonitor(Base.AEMonitor):
  '''  
  Abstract base class for L{EventMonitor}s that will buffer events. Defines
  methods that must be overriden to get the names of all events to monitor and
  which events should be buffered by default.
  '''
  def getEventType(self):
    '''
    Abstract method. Gets the base class indicating the type of event of 
    interest to this monitor.
    
    @return: Base type of the event this monitor should buffer
    @rtype: class
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError
  
  def getEventNames(self):
    '''
    Abstract method. Gets names identifying all possible kinds of events to be
    monitored. The names are used to determine which events are actually 
    buffered once received by the monitored and which are ignored.
    
    @return: All event kinds to potentially buffer
    @rtype: list of string
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError
  
  def getEventDefaults(self):
    '''
    Abstract method. Gets the names of events returned by L{getEventNames} that
    will be buffered by default.
    
    @return: Default event kinds to buffer
    @rtype: list of string
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError
  
  def show(self, **kwargs):
    '''
    Abstract method. Buffers the given key word arguments. It is up to the
    monitor that implements this method to decide how to interpret and show the
    given data.
    
    @param kwargs: Information to buffer
    @type kwargs: dictionary
    @raise IOError: When the monitor is no longer accepting data to buffer 
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError