clc; clear; close all;

pkg load signal;
pkg load control;

sampleRate      = 48000;
faustDSPtarget  = fullfile(                             ...
                            '..',                       ...
                            '..',                       ...
                            'Faust',                    ...
                            'testBeds',                 ...
                            'wienerHammerstein2.dsp'     ...
                            );
dataTarget      = fullfile(                             ...
                            '..',                       ...
                            '..',                       ...
                            'Faust',                    ...
                            'testBeds',                 ...
                            'wienerHammerstein2.mat'     ...
                            );
permission      = 'w';
precision       = '%.18f';
antialFIRTaps   = 16;
windowFcn       = @chebwin;
finalFrequency  = 23000;
nBranches       = 20;

[z, p, k]   = butter(2, 2 * 27.5 / sampleRate, 'high');
[b, a]      = zp2tf(z, p, k);
[SOS, G]    = zp2sos(z, p, k);

antiAl      = zeros(nBranches, antialFIRTaps);

for n = 1:nBranches
    
    antiAl(n, :) = fir1(                                     ...
                antialFIRTaps - 1,                           ...
                (2.0 * finalFrequency) / (n * sampleRate),   ...
                'lowpass',                                   ...
                windowFcn(antialFIRTaps)                     ...
                );
    
endfor

fileID = fopen(faustDSPtarget, permission);

fprintf(fileID, ...
            'fi = library("filters.lib");\nba = library("basics.lib");\n\n' ...
            );
            
for n = 1:nBranches
    
    fprintf(fileID, ...
            ['br' num2str(n) ' = fi.fir(('] ...
            );
            
    for t = 1:size(antiAl, 2)
            
        fprintf(fileID, num2str(antiAl(n, t), precision));
        
        if isequal(t, size(antiAl, 2))
            fprintf(fileID, ')');
        else
            fprintf(fileID, ', ');
         endif
        
    endfor
    
    fprintf(fileID, ...
        [') : ^(_, ' num2str(n) ') : fi.tf22t(' ...
        num2str(SOS(1), precision) ', ' ...
        num2str(SOS(2), precision) ', ' ...
        num2str(SOS(3), precision) ', ' ...
        num2str(SOS(5), precision) ', ' ...
        num2str(SOS(6), precision) ') : ' ...
        ' *(_, ' num2str(G, precision) ') : ' ...
        '*(_, brG)\n'
        ] ...
        );
        
    fprintf(fileID,                                                         ...
            ['with{\n'                                                   ...
            '    brG= hslider(' ...
            '"[' num2str(n - 1) ']Gain Adjust Branch ' num2str(n) ...
            '[unit:dB][style:knob]",'   ...
            '0, -120, 120, 0.1) : ba.db2linear;\n'                      ...
            '};\n\n'                                                    ...
            ]                                                           ...
            );
        
    
    
endfor

fprintf(fileID, 'process = _ <: ');

for n = 1:nBranches
    
    fprintf(fileID, ['br' num2str(n)]);
    
    if isequal(n, nBranches)
        fprintf(fileID, ' :> _;\n');
    else
        fprintf(fileID, ', ');
    endif
    
endfor

fclose(fileID);

save(dataTarget, 'b', 'a', 'antialFIRTaps');