#
# "@(#) $Id: crushToAscii.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import re

#
# the function "crush" maps accented latin-1 characters to the ASCII range
#
xlate = {
0xa2: 'c',
0xa5: 'Y',
0xa6: 'l',
0xa7: 's',
0xa8: '.',
0xa9: 'c',
0xaa: 'a',
0xab: '(',
0xac: 'L',
0xad: '-',
0xae: 'r',
0xaf: '-',
0xb0: 'o',
0xb1: '-',
0xb2: '2',
0xb3: '3',
0xb5: 'u',
0xb6: 'P',
0xb7: 'o',
0xb9: '1',
0xba: 'o',
0xbb: ')',
0xbc: '14',
0xbd: '12',
0xbe: '34',
0xbf: '?',
0xc0: 'A',
0xc1: 'A',
0xc2: 'A',
0xc3: 'A',
0xc4: 'A',
0xc5: 'A',
0xc6: 'AE',
0xc7: 'C',
0xc8: 'E',
0xc9: 'E',
0xca: 'E',
0xcb: 'E',
0xcc: 'I',
0xcd: 'I',
0xce: 'I',
0xcf: 'I',
0xd0: 'D',
0xd1: 'N',
0xd2: 'O',
0xd3: 'O',
0xd4: 'O',
0xd5: 'O',
0xd6: 'O',
0xd7: 'x',
0xd8: 'O',
0xd9: 'U',
0xda: 'U',
0xdb: 'U',
0xdc: 'U',
0xdd: 'Y',
0xde: 'P',
0xdf: 'S',
0xe0: 'a',
0xe1: 'a',
0xe2: 'a',
0xe3: 'a',
0xe4: 'a',
0xe5: 'a',
0xe6: 'ae',
0xe7: 'c',
0xe8: 'e',
0xe9: 'e',
0xea: 'e',
0xeb: 'e',
0xec: 'i',
0xed: 'i',
0xee: 'i',
0xef: 'i',
0xf0: 'o',
0xf1: 'n',
0xf2: 'o',
0xf3: 'o',
0xf4: 'o',
0xf5: 'o',
0xf6: 'o',
0xf7: '-',
0xf8: 'o',
0xf9: 'u',
0xfa: 'u',
0xfb: 'u',
0xfc: 'u',
0xfd: 'y',
0xfe: 'p',
0xff: 'y'}

nonasciire = re.compile(u'([\x00-\x7f]+)|([^\x00-\0x7f])',re.UNICODE).sub

def crush(s):
	return str(nonasciire(lambda x: x.group(1) or xlate.setdefault(ord(x.group(2)),''),s))

if __name__=='__main__':
	s = unicode('','latin-1')
	for c in range(32,256):
		if c!=0x7f:
			s = s + unicode(chr(c),'latin-1')
	plainAscii = crush(s)
	print s
	print plainAscii
	print "done"
