#
# LTrayToolTip.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LMusicPlayer import *

class LTrayToolTip(QToolTip):
	def __init__(self,parent = None,group = None):
		QToolTip.__init__(self,parent,group)
		self.parent = parent
		self.artist = ""
		self.album = ""
		self.title = ""
		QObject.connect(LMusicPlayer.singleton(),PYSIGNAL("status"),self.gotStatus)
	
	def gotStatus(self,status):
		try:
			if status.has_key("Track"):
				track = status["Track"]
				try: self.artist = track.artist
				except: pass
				try: self.album = track.album
				except: pass
				try: self.title = track.title
				except: pass
		except: pass

	def maybeTip(self,p):
		t = "Lsongs"
		if len(self.title)>0:
			t= self.title
			if len(self.album)>0:
				t = u"%s - %s" % (t,self.album)
			if len(self.artist)>0:
				t = u"%s - %s" %(self.artist,t)
		self.tip(self.parent.rect(),t)
