#
# "@(#) $Id: LTrashView.py,v 1.5 2004/08/04 01:01:47 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from LLibraryView import *
from LPlaylistView import *
from LTrashViewItem import *

class LTrashView(LPlaylistView):
	def __init__(self,container):
		LPlaylistView.__init__(self,container)
	
	def setCurrentPlaylist(self):
		pass

	def loadHeaders(self):
		headers = [i18n("Song Name"),i18n("Time"),i18n("Artist"),i18n("Album"),i18n("Genre")]
		widths = [220,40,120,180,80]
		for index in xrange(0,len(headers)):
			self.addColumn(headers[index],widths[index])
		self.setShowSortIndicator(True)
		self.setFullWidth(True)
		#self.setColumnAlignment(8,Qt.AlignCenter)
		#self.ratingColumn = 7
		self.ratingColumn = 99
		sortColumn = self.settings.get('Trash Sort Column',0)
		sortAscending = self.settings.get('Trash Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)
		QObject.connect(self.header(),SIGNAL("indexChange(int,int,int)"),self.columnIndexChanged)
		QObject.connect(self.header(),SIGNAL("sizeChange(int,int,int)"),self.columnSizeChanged)
		self.loadHeaderSizes('Trash Header Widths')
		self.loadHeaderOrdering('Trash Header Map')

	def loadTracks(self):
		pass

	def setPlaylist(self,playlist):
		self.playlistName = playlist.name
		self.playlist = playlist
		self.playlist.connect(PYSIGNAL("addedTrack"),self.refresh)
		self.playlist.connect(PYSIGNAL("removedTracks"),self.refresh)
		self.loadPlaylistItems()

	def loadPlaylistItems(self):
		self.clear()
		index = 1
		tracks = self.playlist.tracks
		for track in tracks:
			self.loadTrackItemForIndex(track,index)
			index = index+1
		self.emitCurrentEnabledSortedTracks()

	def loadTrackItemForIndex(self,track,index):
		item = LTrashViewItem(self,track)

	def canBurn(self):
		return False
	
	def canPlay(self):
		return False

	def canShowLocation(self):
		return False
	
	def canGetInfo(self):
		return False

	def refresh(self):
		self.loadPlaylistItems()

	def doSelectionChanged(self):
		LLibraryView.doSelectionChanged(self)
		self.emit(PYSIGNAL("selectionChanged"),(self,None))

	def setSorting(self,column,ascending):
		KListView.setSorting(self,column,ascending)
		self.settings['Trash Sort Column'] = column
		self.settings['Trash Sort Ascending'] = not not ascending

	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('Trash Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('Trash Header Widths')

	def removeSelectedItems(self):
		trackIDs = self.selectedTrackIDs()
		self.library.removeTrackIDsFromTrash(trackIDs)

	def contextMenu(self,item,pos,col):
		pass
	
	def contentsDragEnterEvent(self,event):
		pass
	
	def contentsDropEvent(self,event):
		pass

	def acceptDrag(self,event):
		return False
