#
# "@(#) $Id: LTrackView.py,v 1.13 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LMusicPlayer import *
from LSettings import *
from LGetMultiInfoDialog import *
from utils import *
from human import *

class LTrackView:
	def __init__(self):
		self.playlist = None
		self.settings = LSettings.settings()
		self.searchType = 'all'
		self.searchText = ''
	
	def canBrowse(self):
		return False
	
	def browserShowing(self):
		return False
	
	def showBrowser(self):
		pass
	
	def hideBrowser(self):
		pass
	
	def selectAll(self,select = True):
		pass
	
	def selectedTrackIDs(self):
		return []
	
	def randomTrackID(self):
		return None
	
	def randomTrack(self):
		return None
	
	def canPlay(self):
		return False
	
	def canImport(self):
		return False

	def canBurn(self):
		return False
	
	def canExport(self):
		return True

	def canGetInfo(self):
		return True

	def canShowLocation(self):
		return False
	
	def canShowCurrent(self):
		return False

	def canStream(self):
		return False
	
	def canDelete(self):
		return True
	
	def canEject(self):
		return False
	
	def canSync(self):
		return False

	def getCurrentEnabledSortedTracks(self):
		result = []
		item = self.firstChild()
		while item:
			track = item.track()
			#if track.enabled:
			result.append(track)
			item = item.itemBelow()
		return result
	
	def emitCurrentEnabledSortedTracks(self):
		tracks = self.getCurrentEnabledSortedTracks()
		#print "emitting current sorted tracks"
		if self.playlist:
			LMusicPlayer.setCurrentTrackList(self.library,self.playlist,tracks)
			self.playlist.updateCurrentTracks(tracks)
	
	def aboutToDie(self):
		pass

	def loadHeaderSizes(self,tag):
		sizes = self.settings.get(tag,None)
		if sizes:
			h = self.header()
			section = 0
			for size in sizes:
				h.resizeSection(section,size)
				section = section+1

	def loadHeaderOrdering(self,tag):
		indices = self.settings.get(tag,None)
		if indices:
			h = self.header()
			section = 0
			for index in indices:
				h.moveSection(section,index)
				section = section+1
	
	def saveHeaderOrdering(self,tag):
		h = self.header()
		indices = [h.mapToIndex(section) for section in range(0,h.count())]
		self.settings[tag] = indices

	def saveHeaderSizes(self,tag):
		h = self.header()
		sizes = [h.sectionSize(section) for section in range(0,h.count())]
		self.settings[tag] = sizes

	def matchesSearch(self,track):
		if self.searchText=='':
			return True
		searchText = self.searchText.lower().split()
		for search in searchText:
			if not self.matchSearchItem(track,search):
				return False
		return True
	
	def matchSearchItem(self,track,searchText):
		if self.searchType=='all' or self.searchType=='artists':
			if track.artist and unikode(track.artist.lower()).find(searchText)>=0:
				return True
		if self.searchType=='all' or self.searchType=='albums':
			if track.album and unikode(track.album.lower()).find(searchText)>=0:
				return True
		if self.searchType=='all' or self.searchType=='titles':
			if track.title and unikode(track.title.lower()).find(searchText)>=0:
				return True
		if self.searchType=='all' or self.searchType=='composers':
			if track.composer and unikode(track.composer.lower()).find(searchText)>=0:
				return True
		if self.searchType=='genres':
			if track.genre and unikode(track.genre.lower()).find(searchText)>=0:
				return True
		return False

	def getMultiInfoForTrackIDs(self,trackIDs):
		lib = self.library
		tracks = lib.tracksWithTrackIDs(trackIDs)
		getInfoDialog = LGetMultiInfoDialog(tracks)
		ret = getInfoDialog.exec_loop()
		if ret==QDialog.Accepted:
			tags = getInfoDialog.unload()
			getInfoDialog.hide()
			if len(tags)>0:
				progress = QProgressDialog(None,"progress",True)
				progress.setMinimumDuration(0)
				progress.setCaption(i18n("Modifying Tracks"))
				progress.setTotalSteps(len(tracks))
				index = 0
				for track in tracks:
					progress.setProgress(index)
					progress.setLabelText(track.title)
					track.loadTagsFrom(tags)
					index = index+1
				progress.setProgress(len(tracks))
				lib.markDirty()
			del getInfoDialog

	def getSummary(self):
		totalCount = 0
		totalDuration = 0
		totalSize = 0
		item = self.firstChild()
		while item:
			track = item.track()
			totalCount = totalCount+1
			if track.totalTime:
				totalDuration = totalDuration+track.totalTime
			if track.size:
				totalSize = totalSize+track.size
			item = item.itemBelow()
		if totalCount==0:
			return ""
		else:
			word = unikode(i18n("tracks"))
			if totalCount==1: word = unikode(i18n("track"))
			return u"%d %s, %s, %s" % (totalCount,word,humanDuration(totalDuration),humanFileSize(totalSize))
	
	def showSongItemForTrack(self,track):
		item = self.firstChild()
		while item:
			if item.track()==track:
				self.ensureItemVisible(item)
				break
			item = item.itemBelow()
