#
# "@(#) $Id: LStatusWidget.py,v 1.7 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LPixmapPushButton import *
from LStatusLogoProgressView import *
from LStatusPlayerProgressView import *
from LStatusRipperProgressView import *
from LStatusEncoderProgressView import *
from LStatusImporterProgressView import *
from LStatusBurnerProgressView import *
from LStatusImporterProgressView import *
from LStatusCDMounterProgressView import *

from LStatusDellMounterProgressView import *
from LStatusDellImporterProgressView import *
from LStatusDellExporterProgressView import *
from LStatusDellSyncerProgressView  import *

from LStatusPodExporterProgressView import *
from LStatusPodImporterProgressView import *
from LStatusPodUpdaterProgressView import *

from LStatusDownloadProgressView import *
from LStatusBrowserProgressView import *
from LStatusUploaderProgressView import *
from LStatusSyncerProgressView import *
from LsongsPaths import *

class LStatusWidget(QWidget):
	def __init__(self,container):
		QWidget.__init__(self,container)
		self.setFixedHeight(70)
		self.setMinimumWidth(175)
		self.left = QPixmap(art("backgroundstatusleft.png"))
		self.right = QPixmap(art("backgroundstatusright.png"))
		self.middle = QBrush()
		self.middle.setPixmap(QPixmap(art("backgroundstatusmiddle.png")))
		vlayout = QVBoxLayout(self)
		vlayout.setMargin(0)
		hlayout = QHBoxLayout()
		vlayout.addLayout(hlayout)
		hlayout.addItem(QSpacerItem(10,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		arrow = QIconSet(QPixmap(art("buttonstatusarrow.png")))
		self.advanceButton = LSmallPixmapPushButton(arrow,"",self)
		QToolTip.add(self.advanceButton,i18n("Switch between status views"))
		QObject.connect(self.advanceButton,SIGNAL("clicked()"),self.nextStatus)
		hlayout.addWidget(self.advanceButton)
		self.advanceButton.hide()
		hlayout.addItem(QSpacerItem(4,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		self.stack = QWidgetStack(self)
		self.stack.setFrameStyle(QFrame.Box)
		self.stack.setLineWidth(2)
		self.stack.setMargin(0)
		hlayout.addWidget(self.stack)
		self.addLogoProgressView(self.stack)
		self.addPlayerProgressView(self.stack)
		self.addRipperProgressView(self.stack)
		self.addEncoderProgressView(self.stack)
		self.addBurnerProgressView(self.stack)
		self.addImporterProgressView(self.stack)
		self.addCDMounterProgressView(self.stack)
		
		self.addDellMounterProgressView(self.stack)
		self.addDellImporterProgressView(self.stack)
		self.addDellExporterProgressView(self.stack)
		self.addDellSyncerProgressView(self.stack)
		
		self.addPodExporterProgressView(self.stack)
		self.addPodImporterProgressView(self.stack)
		self.addPodUpdaterProgressView(self.stack)
		
		self.addDownloadProgressView(self.stack)
		self.addBrowserProgressView(self.stack)
		self.addUploaderProgressView(self.stack)
		self.addSyncerProgressView(self.stack)
		self.views = []
		hlayout.addItem(QSpacerItem(25,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		self.stack.setFixedHeight(60)

	def addLogoProgressView(self,container):
		self.logoProgressView = LStatusLogoProgressView(container)

	def addPlayerProgressView(self,container):
		self.playerProgressView = LStatusPlayerProgressView(container,self)

	def addRipperProgressView(self,container):
		self.ripperProgressView = LStatusRipperProgressView(container,self)

	def addEncoderProgressView(self,container):
		self.encoderProgressView = LStatusEncoderProgressView(container,self)

	def addBurnerProgressView(self,container):
		self.burnerProgressView = LStatusBurnerProgressView(container,self)

	def addImporterProgressView(self,container):
		self.importerProgressView = LStatusImporterProgressView(container,self)
	
	def addCDMounterProgressView(self,container):
		self.cdMounterProgressView = LStatusCDMounterProgressView(container,self)

	def addDellMounterProgressView(self,container):
		self.dellMounterProgressView = LStatusDellMounterProgressView(container,self)

	def addDellImporterProgressView(self,container):
		self.dellImporterProgressView = LStatusDellImporterProgressView(container,self)

	def addDellExporterProgressView(self,container):
		self.dellExporterProgressView = LStatusDellExporterProgressView(container,self)

	def addDellSyncerProgressView(self,container):
		self.dellSyncerProgressView = LStatusDellSyncerProgressView(container,self)
	
	def addPodImporterProgressView(self,container):
		self.podImporterProgressView = LStatusPodImporterProgressView(container,self)

	def addPodExporterProgressView(self,container):
		self.podExporterProgressView = LStatusPodExporterProgressView(container,self)

	def addPodUpdaterProgressView(self,container):
		self.podUpdaterProgressView = LStatusPodUpdaterProgressView(container,self)

	def addDownloadProgressView(self,container):
		self.downloadProgressView = LStatusDownloadProgressView(container,self)

	def addBrowserProgressView(self,container):
		self.browserProgressView = LStatusBrowserProgressView(container,self)

	def addUploaderProgressView(self,container):
		self.uploaderProgressView = LStatusUploaderProgressView(container,self)

	def addSyncerProgressView(self,container):
		self.syncerProgressView = LStatusSyncerProgressView(container,self)

	def paintEvent(self,ev):
		global _left,_middle,_right,_logo
		r = self.rect()
		p = QPainter()
		p.begin(self)
		p.setPen(Qt.NoPen)
		p.drawPixmap(QPoint(0,0),self.left)
		p.drawPixmap(QPoint(r.width()-self.right.width(),0),self.right)
		p.setBrush(self.middle)
		fill = QRect(self.left.width(),0,r.width()-self.left.width()-self.right.width(),self.left.height())
		p.drawRect(fill)
		p.end()

	def showStatus(self,view):
		#print "attempting to show",view
		try: index = self.views.index(view)
		except:
			self.views.append(view)
			self.stack.raiseWidget(view)
			if len(self.views)>1:
				self.advanceButton.show()
	
	def hideStatus(self,view):
		#print "attempting to hide",view
		try:
			index = self.views.index(view)
			self.views.remove(view)
			if len(self.views)==0:
				self.stack.raiseWidget(self.logoProgressView)
			elif index>=len(self.views):
				self.stack.raiseWidget(self.views[0])
			else:
				self.stack.raiseWidget(self.views[index])
			if len(self.views)<=1:
				self.advanceButton.hide()
		except: pass
	
	def nextStatus(self):
		if len(self.views)>0:
			index = self.views.index(self.stack.visibleWidget())+1
			if index>=len(self.views):
				index = 0
			self.stack.raiseWidget(self.views[index])
