#
# "@(#) $Id: LStatusDellMounterProgressView.py,v 1.4 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LBarberPoleView import *
from LMusicDellMounter import *
from LPixmapPushButton import *
from LsongsPaths import *

_backColor = QColor(172,191,238)

class LStatusDellMounterProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.buildViews()
		QObject.connect(LMusicDellMounter.singleton(),PYSIGNAL("status"),self.progress)
	
	def buildViews(self):
		#f = QFont("fixed",6)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		#self.title = QLabel(i18n("Mounting Dell Digital"),self)
		self.title = KSqueezedTextLabel(self)
		self.title.setText(i18n("Reading Dell Digital Jukebox"))
		#self.title.setFont(f)
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.elapsed = QLabel(i18n("Completion"),self)
		#self.elapsed.setFont(f)
		self.elapsed.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.elapsed)
		playout = QHBoxLayout()
		vlayout.addLayout(playout)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		self.barberPoleView = LBarberPoleView(self)
		playout.addWidget(self.barberPoleView,100)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		cancelIcon = QIconSet(QPixmap(art("buttonstatuscancel.png")))
		self.cancelButton = LSmallPixmapPushButton(cancelIcon,"",self)
		QToolTip.add(self.cancelButton,i18n("Cancel the mount of the Dell Digital Jukebox"))
		QObject.connect(self.cancelButton,SIGNAL("clicked()"),self.cancelImport)
		hlayout.addWidget(self.cancelButton)
		
	def progress(self,status):
		#print "status view got progress"
		#self.progressView.progress(status)
		state = status['Status']
		if state=='Begin':
			self.statusView.showStatus(self)
		elif state=='End':
			self.statusView.hideStatus(self)

	def cancelImport(self):
		LMusicDellMounter.killCurrentDellMounter()
