#
# "@(#) $Id: LStatusCDMounterProgressView.py,v 1.7 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *
from LStatusProgressBar import *
from LBarberPoleView import *
#from LMusicCDMounter import *
from CDLibrary import *
from LPixmapPushButton import *
from LsongsPaths import *
from utils import *

_backColor = QColor(172,191,238)

class LStatusCDMounterProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.buildViews()
		#QObject.connect(LMusicCDMounter.singleton(),PYSIGNAL("status"),self.progress)
		QObject.connect(CDLibraries.singleton(),PYSIGNAL("status"),self.progress)
	
	def buildViews(self):
		#f = QFont("fixed",6)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.title = QLabel(i18n("Song Name"),self)
		#self.title = KSqueezedTextLabel(self)
		#self.title.setText("Song Name")
		#self.title.setFont(f)
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.elapsed = QLabel(i18n("Completion"),self)
		#self.elapsed.setFont(f)
		self.elapsed.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.elapsed)
		self.progressView = LStatusProgressBar(self)
		vlayout.addWidget(self.progressView)
		self.barberPoleView = LBarberPoleView(self)
		vlayout.addWidget(self.barberPoleView)
		self.barberPoleView.hide()
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		cancelIcon = QIconSet(QPixmap(art("buttonstatuscancel.png")))
		self.cancelButton = LSmallPixmapPushButton(cancelIcon,"",self)
		QToolTip.add(self.cancelButton,i18n("Cancel the mount of the CD"))
		QObject.connect(self.cancelButton,SIGNAL("clicked()"),self.cancelImport)
		hlayout.addWidget(self.cancelButton)
		
	def progress(self,status):
		#print "status view got progress"
		self.progressView.progress(status)
		state = status['Status']
		if state=='Begin':
			self.title.setText(i18n("Searching CD Track Database"))
			self.elapsed.setText('')
			self.progressView.hide()
			self.barberPoleView.show()
			self.statusView.showStatus(self)
##		elif state=='Importing':
##			self.barberPoleView.hide()
##			self.progressView.show()
##			self.title.setText(unikode(i18n('Reading: Track %d')) % (status['currentTime']+1))
##			self.elapsed.setText(unikode(i18n("%d of %d")) %(status['currentTime']+1,status['totalTime']))
		elif state=='End':
			self.statusView.hideStatus(self)

	def cancelImport(self):
		#LMusicCDMounter.killCurrentCDMounter()
		CDLibraries.singleton().killTasks()
