#
# "@(#) $Id: LStationsView.py,v 1.2 2004/08/04 01:01:47 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LTrackView import *
from LWebStationView import *
from LRadioView import *
from LPixmapPushButton import *
from LsongsPaths import *

class LStationsView(LTrackView,QWidget):
	def __init__(self,window,container = None,name = 'stations'):
		self.window = window
		LTrackView.__init__(self)
		QWidget.__init__(self,container,name)
		self.currentView = None
		self.subView = None
		self.buildViews()
	
	def buildViews(self):
		self.layout = QVBoxLayout(self)
		self.buildBar(self,self.layout)
		self.buildSubviews(self,self.layout)
	
	def buildBar(self,container,containerLayout):
		layout = QHBoxLayout()
		containerLayout.addLayout(layout)
		iconSet = QIconSet(QPixmap(art("buttonsc.png")),QIconSet.Large)
		self.shoutCast = LPixmapPushButton(iconSet,"",container)
		QObject.connect(self.shoutCast,SIGNAL("released()"),self.hitShoutCast)
		layout.addWidget(self.shoutCast)
		layout.addItem(QSpacerItem(10,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		self.myStations = QPushButton(i18n("My Stations"),container)
		layout.addWidget(self.myStations)
		QObject.connect(self.myStations,SIGNAL("released()"),self.hitMyStations)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
	
	def hitShoutCast(self):
		if self.currentView!='shoutcast':
			self.killCurrentView()
			self.buildShoutcastView(self,self.layout)
			self.window.updateMenusAndControls()
	
	def hitMyStations(self):
		if self.currentView!='mystations':
			self.killCurrentView()
			self.buildMyStationsView(self,self.layout)
			self.window.updateMenusAndControls()

	def killCurrentView(self):
		if self.subView:
			if self.currentView=='shoutcast':
				self.hideShoutcastView()
			else:
				self.subView.deleteLater()
				self.subView = None
				self.currentView = ''
	#
	# we do reparenting here due to bugs in PyKDE
	#
	def buildSubviews(self,container,containerLayout):
		self.buildShoutcastView(container,containerLayout)

	#
	# handle the Shoutcast view
	#
	# due to a bug in PyKDE, we have to build it once and reuse it
	# we save it inbetween uses by reparenting it to the main
	# window and hiding it
	#
	def buildShoutcastView(self,container,containerLayout):
		if self.window.browserView:
			self.subView = self.window.browserView
			self.subView.reparent(container,0,QPoint(0,0),True)
		else:
			self.subView = LWebStationView(container)
		containerLayout.addWidget(self.subView)
		self.currentView = 'shoutcast'

	def hideShoutcastView(self):
		self.window.browserView = self.subView
		self.subView.reparent(self.window,0,QPoint(0,0),False)
		self.subView = None
	
	def buildMyStationsView(self,container,containerLayout):
		self.subView = LRadioView(container)
		containerLayout.addWidget(self.subView)
		self.subView.show()
		self.currentView = 'mystations'

	def canBurn(self):
		return False
	
	def canExport(self):
		return False

	def getSummary(self):
		return ""
	
	def aboutToDie(self):
		if self.currentView=='shoutcast':
			self.hideShoutcastView()

	def canStream(self):
		return self.currentView=='mystations'

	def addStream(self):
		if self.currentView=='mystations':
			self.subView.addStream()
