#
# LSlimp3View.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LsongsPaths import *
from utils import *
from LTrackView import *

class LSlimp3View(LTrackView,QVBox):
	def __init__(self,window,container,name,type,address,port):
		self.window = window
		LTrackView.__init__(self)
		QVBox.__init__(self,container,'slimp3')
		self.name = name
		self.type = type
		self.address = address
		self.port = port
		#self.setSpacing(2)
		self.buildViews()

	def buildViews(self):
		self.buildNavBar()
		self.buildBrowser()

	def buildNavBar(self):
		bar = QWidget(self)
		layout = QHBoxLayout(bar)
		layout.setSpacing(5)
		bSize = QSize(28,22)
##~ 		self.backButton = QPushButton(QIconSet(QPixmap(art("buttonback.png"))),"",bar)
##~ 		self.backButton.setFixedSize(bSize)
##~ 		layout.addWidget(self.backButton)
##~ 		self.forwardButton = QPushButton(QIconSet(QPixmap(art("buttonforward.png"))),"",bar)
##~ 		self.forwardButton.setFixedSize(bSize)
##~ 		layout.addWidget(self.forwardButton)
		self.homeButton = QPushButton(QIconSet(QPixmap(art("buttonhome.png"))),"",bar)
		self.homeButton.setFixedSize(bSize)
		layout.addWidget(self.homeButton)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
##~ 		QObject.connect(self.backButton,SIGNAL("released()"),self.back)
##~ 		QObject.connect(self.forwardButton,SIGNAL("released()"),self.forward)
		QObject.connect(self.homeButton,SIGNAL("released()"),self.home)

	def buildBrowser(self):
		self.makeBrowserView(self,self.layout())
		self.connect(self.browser.browserExtension(),SIGNAL("openURLRequest(const KURL &, const KParts::URLArgs &)"),self.doRequest)
		self.home()

	def doRequest(self,kurl,args = None):
		path = unikode(kurl.url())
		(root,ext) = os.path.splitext(path)
		if args:
			self.browser.browserExtension().setURLArgs(args)
		self.browser.openURL(kurl)

	def homeURL(self):
		return "http://%s:%d" % (self.address,self.port)

	def home(self):
		self.doRequest(KURL(self.homeURL()))

	def back(self):
		KMessageBox.error(self,"Slimp3 'back' not implemented","Not Implemented")

	def forward(self):
		KMessageBox.error(self,"Slimp3 'forward' not implemented","Not Implemented")

	def canBurn(self):
		return False
	
	def canExport(self):
		return False

	def getSummary(self):
		return ""

	def aboutToDie(self):
		self.hideBrowserView()
	
	#
	# handle the browser
	#
	# due to a bug in PyKDE, we have to build it once and reuse it
	# we save it inbetween uses by reparenting it to the main
	# window and hiding it
	#
	def makeBrowserView(self,container,containerLayout):
		if self.window.slimp3View:
			self.browserBox = self.window.slimp3View
			self.browser = self.browserBox.browser
		else:
			from khtml import KHTMLPart
			self.browserBox = QVBox()
			#containerLayout.addWidget(self.browserBox)
			self.browser = KHTMLPart(self.browserBox)
			self.browserBox.browser = self.browser
		self.browserBox.reparent(container,0,QPoint(0,0),True)

	def hideBrowserView(self):
		self.window.slimp3View = self.browserBox
		self.browserBox.reparent(self.window,0,QPoint(0,0),False)
		self.browserBox = None
