#
# LRatingMenuItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from kdecore import *
from qt import *
from LsongsPaths import *

_star = None
def star():
	global _star
	if _star==None:
		_star = QPixmap(art("labelstar.png"))
	return _star


class LRatingMenuItem(QCustomMenuItem):
	def __init__(self,rating = 5):
		QCustomMenuItem.__init__(self)
		self.rating = rating
	
	def paint(self,p,cg,act,enabled,x,y,w,h):
		try:
			s = star()
			for i in xrange(0,self.rating):
				p.drawPixmap(QPoint(i*13+3+x,2+y),s)
		except: pass
	
	def sizeHint(self):
		return QSize(100,20)

class LRatingMenu(QPopupMenu):
	def __init__(self):
		QPopupMenu.__init__(self)
		self.insertItem(i18n("None"),0)
		for  i in xrange(1,6):
			self.insertItem(LRatingMenuItem(i),i)
		self.setRating(0)
		QObject.connect(self,SIGNAL("activated(int)"),self.hitRating)
	
	def setRating(self,id):
		for i in xrange(0,6):
			self.setItemChecked(i,i==id)

	def hitRating(self,i):
		self.setRating(i)
		self.emit(PYSIGNAL("setRating"),(i,None))
		
