#
# LPodDeviceSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LSourceViewItem import *
from LTrackDrag import *
from PodLibrary import *
from LPodPlaylistSourceViewItem import *
from LPodInfoDialog import *
from LMusicPodManager import *

#
# iPod Player devices
#
class LPodDeviceSourceViewItem(LSourceViewItem):
	def __init__(self,container):
		lib = PodLibrary.singleton()
		name = "iPod"
		LSourceViewItem.__init__(self,container,name)
		self.library = lib
		self.setDropEnabled(True)
		self.wantsFileDrags = False
		self.wantsTrackDrags = True
		self.canExport = True
		self.canBurn = True
		#self.setRenameEnabled(0,True)
		self.library.connect(PYSIGNAL("addedPlaylist"),self.addedPlaylist)
		self.library.connect(PYSIGNAL("removedPlaylist"),self.removedPlaylist)
		self.addCurrentPlaylists()

	def makeKey(self):
		return 'J'+str(self.name)

	def changeName(self,newName):
		pass
		#LMusicPodManager.singleton().setOwnerName(newName)

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		id = self.popup.insertItem(i18n("Get Info..."),self.getInfo)
		id = self.popup.insertItem(i18n("Sync"),self.sync)
		id = self.popup.insertItem(i18n("Eject"),self.eject)
		id = self.popup.insertItem(i18n("Add Playlist"),self.addPlaylist)
	
	def getInfo(self):
		dialog = LPodInfoDialog(self.library)
		dialog.exec_loop()
	
	def sync(self):
		LMusicPodManager.singleton().sync()
	
	def eject(self):
		PodLibrary.unmount()
	
	def addCurrentPlaylists(self):
		for playlist in self.library.playlists:
			item = LPodPlaylistSourceViewItem(self,playlist)

	def addPlaylist(self):
		(name,ok) =  KInputDialog.getText(i18n("Add Player Playlist"),i18n("Name of new playlist:"),"untitled Playlist")
		if ok:
			name = unikode(name)
			if len(name)>0:
				pass
				#self.library.addNewPlaylist(name)
				LMusicPodManager.singleton().addNewPlaylist(name)

	def addedPlaylist(self,library,playlist):
		LPodPlaylistSourceViewItem(self,playlist)
	
	def removedPlaylist(self,library,playlist):
		#print "Pod source item removed remote playlist",playlist.name
		item = self.firstChild()
		while item:
			#print "checking",item.playlist.name
			if item.playlist==playlist:
				if item.isSelected():
					#print item.playlist.name,"is selected!"
					list = self.listView()
					if list:
						list.setSelected(list.master,True)
						list.master.select(list)
				self.takeItem(item)
				del item
				break
			item = item.nextSibling()

	def iconFileName(self): return "sourcedevice.png"
	
	def select(self,container):
		self.setOpen(not self.isOpen())

	#
	# allow track drags from anywhere
	#
	def acceptDrag(self,event):
		if LTrackDrag.canDecode(event): return True
		if LPlaylistDrag.canDecode(event): return True
		return False

	#
	# handle track and playlist drags
	#
	def dropped(self,event):
		if LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			library = Library.mainLibrary()
			tracks = library.tracksWithTrackIDs(trackIDs)
			tracks = filter(lambda track: track.kind.startswith('MPEG'),tracks)
			if len(tracks)>0:
				#print "LPodDeviceSourceViewItem.dropped: dropping tracks",tracks
				LMusicPodManager.singleton().uploadTracksToPlaylist(self.library.mainPlaylist,tracks)
				pass
			return
		if LPlaylistDrag.canDecode(event):
			drag = LPlaylistDrag.decode(event)
			library = Library.mainLibrary()
			playlist = library.playlistWithName(drag['Playlist'])
			if playlist:
				tracks = playlist.getTracks()
				LMusicPodManager.singleton().addNewPlaylist(drag['Playlist'])
				LMusicPodManager.singleton().refresh()
				LMusicPodManager.singleton().uploadTracksToPlaylist(drag['Playlist'],tracks)
				print "LPodDeviceSourceViewItem.dropped: dropping playlist",drag['Playlist']
			return
				
