#
# "@(#) $Id: LPlaylistViewItem.py,v 1.6 2004/07/26 16:46:23 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from LLibraryViewItem import *

class LPlaylistViewItem(LLibraryViewItem):
	def __init__(self,container,track,index):
		self.index = index
		LLibraryViewItem.__init__(self,container,track)
	
	def setColumnIndices(self):
		self.indexColumn = 1
		self.titleColumn = 2
		self.durationColumn = 3
		self.artistColumn = 4
		self.albumColumn = 5
		self.genreColumn = 6
		self.ratingColumn = 7
		self.playCountColumn = 8
		self.playDateColumn = 9
	
	def setIndex(self,index):
		self.index = index
		self.updateIndex()
	
	def loadTrackInfo(self):
		LLibraryViewItem.loadTrackInfo(self)
		self.updateIndex()
	
	def updateIndex(self):
		if self.indexColumn:
			self.setText(self.indexColumn,str(self.index))
		self.indexKey = QString("%06d" % self.index)
	
	def key(self,column,ascending):
		if column==self.indexColumn:
			return self.indexKey
		else:
			return LLibraryViewItem.key(self,column,ascending)
	
	def addCustomContextMenuItems(self,menu):
		menu.insertItem(i18n("Remove from Playlist"),self.removeFromPlaylist)
		menu.insertItem(i18n("Move to Trash"),self.moveToTrash)

	def removeFromPlaylist(self):
		list = self.listView()
		trackIDs = list.selectedTrackIDs()
		list.playlist.removeTrackIDs(trackIDs)
