#
# LOggEncoderProcess.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from LEncoderProcess import *
from utils import *
import crushToAscii
import os,re


class LOggEncoderProcess(LEncoderProcess):
	def extension(self):
		return 'ogg'
	
	def buildCommand(self):
		self.pattern = re.compile(r"\s*?\[\s*?(\d+)\.")
		bitRate = self.settings.get('Encoder Bit Rate',192000)/1000
		self.setExecutable("nice")
		args = ['-n',str(self.settings.get("Encoder Nice",10)),"oggenc",self.wavPath,"-b",str(bitRate),"-o",self.destPath]
		try:
			if self.track.title: args.extend(["-t",unikode(self.track.title).encode('latin-1')])
		except: pass
		try:
			if self.track.artist: args.extend(["-a",unikode(self.track.artist).encode('latin-1')])
		except: pass
		try:
			if self.track.album: args.extend(["-l",unikode(self.track.album).encode('latin-1')])
		except: pass
		try:
			if self.track.genre: args.extend(["-G",self.track.genre])
		except: pass
		try:
			if self.track.trackNum: args.extend(["-N",str(self.track.trackNum)])
		except: pass
		try:
			if self.track.trackCount: args.extend(["-c",("TRACKCOUNT=%d" % self.track.trackCount)])
		except: pass
		try:
			if self.track.year: args.extend(["-d",str(self.track.year)])
		except: pass
		self.convertLineEndings = True
		self.setArguments(args)
		self.emitEvent({'Source':'Encoder','Status':'BeginTrack','Track':self.track})

	def processLines(self,lines):
		line = lines[-1]
		mo = self.pattern.match(line)
		if mo:
			currentTime = long(mo.group(1))
			totalTime = 100
			self.maybeEmitEvent({'Source':'Encoder','Status':'Encoding','currentTime':currentTime,'totalTime':totalTime,'Track':self.track,'Index':self.index,'Count':self.total})
