#
# LMusicUploader.py
#

from qt import *
from kdecore import *
from kio import *
import os, base64,time,crushToAscii
from PListParser import *

class LMusicUploader(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.queue = []
		self.currentJob = None
		self.currentIO = None
	
	def uploadTracks(self,tracks,playlist,library):
		if len(self.queue)==0:
				self.status({'Source':'Uploader','Status':'Begin'});
				self.total = 0
				self.index = 0
		for track in tracks:
			if os.path.exists(track.location):
				self.queue.append({'Track':track,'Playlist':playlist,'Library':library})
				self.total = self.total+1
		self.uploadNextTrack()
	
	def status(self,status):
		self.emit(PYSIGNAL("status"),(status,None))

	def uploadNextTrack(self):
		if self.currentJob==None:
			if len(self.queue)!=0:
				self.index = self.index+1 
				self.currentItem = self.queue[0]
				self.queue = self.queue[1:]
				self.track = self.currentItem['Track']
				library = self.currentItem['Library']
				playlist = self.currentItem['Playlist']
				print "client: uploading",crushToAscii.crush(self.track.location),"to",library.url(),"at",time.time()
				#self.uploadNextTrack()
				url = library.url()+"upload"
				kurl = KURL(url)
				self.currentJob = KIO.put(kurl,-1,True,False,False)
				QObject.connect(self.currentJob,SIGNAL('dataReq(KIO::Job *, QByteArray &)'),self.onDataReq)
				QObject.connect(self.currentJob,SIGNAL('result(KIO::Job *)'),self.onResult)
				
				self.status({'Source':'Uploader','Status':'Encoding','Track':self.track,'currentTime':0,'totalTime':1,'Index':self.index,'Count':self.total});
				plist = self.track.getPList()
				t = type(playlist).__name__
				if playlist:
					if t=='list': plist['Playlists'] = map(lambda p: p.name,playlist)
					else: plist['Playlists'] = [playlist.name] # destination playlist
				else: plist['Playlists']=[]
				try:
					print "client: encoding track at",time.time()
					plist['Data'] = base64.encodestring(open(self.track.location,"rb").read())
					plist = {'Version':'1.0','Track':plist}
					parser = PListWriter()
					trackXML = parser.unparseToString([plist])
					plist = None
					self.currentJob.fileName = "/tmp/lsongs_upload_source"
					open(self.currentJob.fileName,"wb").write(trackXML)
					trackXML= None
					print "client: starting uploader at",time.time()
					self.currentJob.file = open(self.currentJob.fileName,"rb")
					self.currentJob.size = os.fstat(self.currentJob.file.fileno())[6]
					self.status({'Source':'Uploader','Status':'Encoding','Track':self.track,'currentTime':1,'totalTime':1,'Index':self.index,'Count':self.total});
					self.currentJob.resume()
				except:
					self.currentJob = None
					self.uploadNextTrack()
			else:
				print "client: uploading complete"
				self.status({'Source':'Uploader','Status':'End'})
		#else:
		#	print "uploader busy"

	def onDataReq(self,job,bytes):
		#print "reading data from",self.currentJob.file.tell()
		bytes.assign(self.currentJob.file.read(256*1024))
		self.status({'Source':'Uploader','Status':'Uploading','Track':self.track,'currentTime':self.currentJob.file.tell(),'totalTime':self.currentJob.size,'Index':self.index,'Count':self.total});

	def onResult(self,job):
		print "client: upload done at",time.time()
		try:
			self.currentJob.file.close()
			os.remove(self.currentJob.fileName)
		except: pass
		self.currentJob = None
		self.uploadNextTrack()

	def static_singleton():
		global _musicUploaderSingleton
		if _musicUploaderSingleton==None:
			_musicUploaderSingleton = LMusicUploader()
		return _musicUploaderSingleton
	
	singleton = staticmethod(static_singleton)

_musicUploaderSingleton = None
