#
# LMusicBinaryUploader.py
#

from qt import *
from kdecore import *
from kio import *
import os, base64,time,crushToAscii,urllib

class LMusicBinaryUploader(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.queue = []
		self.currentJob = None
		self.currentIO = None
	
	def uploadTracks(self,tracks,playlist,library):
		if len(self.queue)==0:
				self.status({'Source':'Uploader','Status':'Begin'});
				self.total = 0
				self.index = 0
		for track in tracks:
			if os.path.exists(track.location):
				self.queue.append({'Track':track,'Playlist':playlist,'Library':library})
				self.total = self.total+1
		self.uploadNextTrack()
	
	def status(self,status):
		self.emit(PYSIGNAL("status"),(status,None))

	def uploadNextTrack(self):
		if self.currentJob==None:
			if len(self.queue)!=0:
				self.index = self.index+1 
				self.currentItem = self.queue[0]
				self.queue = self.queue[1:]
				self.track = self.currentItem['Track']
				library = self.currentItem['Library']
				playlist = self.currentItem['Playlist']
				#print "client: uploading",crushToAscii.crush(self.track.location),"to",library.url(),"at",time.time()
				#self.uploadNextTrack()
				(root,shortName) = os.path.split(self.track.location)
				#print "file shortName",shortName
				shortName = urllib.quote(shortName)
				#print "encoded",shortName
				url = library.url()+"uploadFast?%s" % shortName
				kurl = KURL(url)
				self.currentJob = KIO.put(kurl,-1,True,False,False)
				QObject.connect(self.currentJob,SIGNAL('dataReq(KIO::Job *, QByteArray &)'),self.onDataReq)
				QObject.connect(self.currentJob,SIGNAL('result(KIO::Job *)'),self.onResult)
				try:
					self.currentJob.fileName = self.track.location
					#print "client: starting uploader at",time.time()
					self.currentJob.file = open(self.currentJob.fileName,"rb")
					self.currentJob.size = os.fstat(self.currentJob.file.fileno())[6]
					self.status({'Source':'Uploader','Status':'Uploading','Track':self.track,'currentTime':0,'totalTime':1,'Index':self.index,'Count':self.total});
					self.currentJob.resume()
				except:
					self.currentJob = None
					self.uploadNextTrack()
			else:
				#print "client: uploading complete"
				self.status({'Source':'Uploader','Status':'End'})
		#else:
		#	print "uploader busy"

	def onDataReq(self,job,bytes):
		#print "reading data from",self.currentJob.file.tell()
		bytes.assign(self.currentJob.file.read(256*1024))
		self.status({'Source':'Uploader','Status':'Uploading','Track':self.track,'currentTime':self.currentJob.file.tell(),'totalTime':self.currentJob.size,'Index':self.index,'Count':self.total});

	def onResult(self,job):
		#print "client: upload done at",time.time()
		try:
			self.currentJob.file.close()
		except: pass
		self.currentJob = None
		self.uploadNextTrack()

	def static_singleton():
		global _musicBinaryUploaderSingleton
		if _musicBinaryUploaderSingleton==None:
			_musicBinaryUploaderSingleton = LMusicBinaryUploader()
		return _musicBinaryUploaderSingleton
	
	singleton = staticmethod(static_singleton)

_musicBinaryUploaderSingleton = None
