#
# "@(#) $Id: LMainLibraryView.py,v 1.9 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LArtistView import *
from LAlbumView import *
from LLibraryView import *
from LTrackView import *
from LSettings import *

class LMainLibraryView(LTrackView,QHBox):
	def __init__(self,container=None,name='none'):
		QHBox.__init__(self,container,name)
		LTrackView.__init__(self)
		self.library = Library.mainLibrary()
		self.settings = LSettings.settings()
		self.buildBrowserAndLibrary(self)
		self.playlistName = "Library"
		self.playlist = self.library.playlistWithName(self.playlistName)
		self.artists.loadFromPrefs()
		#self.albums.loadFromPrefs()

	def closeEvent(self,ev):
		print "closing"
		self.aboutToDie()
		QHBox.closeEvent(ev)

	def aboutToDie(self):
		if self.browserShowing():
			sizes = self.browserAndLibrary.sizes()
			self.settings['Main Library Split'] = str(sizes)
		self.settings['Main Library Browse'] = self.browserShowing()

	def buildBrowserAndLibrary(self,container):
		self.browserAndLibrary = QSplitter(Qt.Vertical,container,"browserAndLibrary")
		#containerLayout.addWidget(self.browserAndLibrary)
		#container.addWidget(self.browserAndLibrary)
		self.browserAndLibrary.setOpaqueResize(True)
		(self.artists,self.albums) = self.buildBrowserView(self.browserAndLibrary)
		self.libraryView = self.buildLibraryView(self.browserAndLibrary)
		self.attachSignals()
		if self.settings.has_key('Main Library Split'):
			sizes = eval(self.settings['Main Library Split'])
			#print sizes
			self.browserAndLibrary.setSizes(sizes)
		if not self.settings.get('Main Library Browse',True):
			self.hideBrowser()

	def attachSignals(self):
		QObject.connect(self.artists,PYSIGNAL("selectArtists"),self.albums.loadAlbumsForArtists)
		#QObject.connect(self.artists,PYSIGNAL("selectArtists"),self.libraryView.loadArtistsAndAlbums)
		QObject.connect(self.albums,PYSIGNAL("selectAlbums"),self.libraryView.loadArtistsAndAlbums)
		#QObject.connect(self.libraryView,SIGNAL('executed(QListViewItem *)'),self.selectedItem)
		QObject.connect(self.libraryView,SIGNAL('selectionChanged()'),self.selectionChanged)
		QObject.connect(self.libraryView,PYSIGNAL('changed'),self.changed)
	
	def detachSignals(self):
		self.artists.disconnect(self.albums.loadAlbumsForArtists)
		self.albums.disconnect(self.libraryView.loadArtistsAndAlbums)
		self.libraryView.disconnect(self.selectionChanged)
		self.libraryView.disconnect(self.changed)
	
	def buildBrowserView(self,container):
		self.browserView = QHBox(container,"browser")
		return (self.buildArtistView(self.browserView),self.buildAlbumView(self.browserView))

	def buildArtistView(self,container):
		return LArtistView(container)

	def buildAlbumView(self,container):
		return LAlbumView(container)

	def buildLibraryView(self,container):
		libraryView = LLibraryView(container,"library")
		return libraryView

	def loadArtistsAndAlbums(self,artists=None,albums=None):
		self.libraryView.loadArtistsAndAlbums(artists,albums)

	def setSearchType(self,searchType):
		self.libraryView.setSearchType(searchType)
	
	def setSearchText(self,searchText):
		self.libraryView.setSearchText(searchText)
	
	def canBrowse(self):
		return True

	def browserShowing(self):
		return self.browserView.parent()==self.browserAndLibrary
		
	def showBrowser(self):
		self.browserView.reparent(self.browserAndLibrary,0,QPoint(0,0),True)
		self.browserAndLibrary.moveToFirst(self.browserView)
		self.browserAndLibrary.setOrientation(Qt.Vertical)
		if self.settings.has_key('Main Library Split'):
			self.browserAndLibrary.setSizes(eval(self.settings['Main Library Split']))
		self.browserView.show()
		self.settings['Main Library Browse'] = True

	def hideBrowser(self):
		sizes = self.browserAndLibrary.sizes()
		self.settings['Main Library Split'] = str(sizes)
		self.browserView.reparent(self,0,QPoint(0,0),False)
		self.browserView.hide()
		self.settings['Main Library Browse'] = False

	def selectAll(self,select = True):
		self.libraryView.selectAll(select)
		
	def selectedTrackIDs(self):
		return self.libraryView.selectedTrackIDs()
	
	def copySelectionToPlaylist(self,playlist):
		self.libraryView.copySelectionToPlaylist(playlist)
	
	def removeSelectedItems(self):
		self.libraryView.removeSelectedItems()

	def selectionChanged(self):
		self.emit(PYSIGNAL("selectedItem"),(self.libraryView.firstSelectedItem(),None))
		self.emit(PYSIGNAL("selectionChanged"),(None,None))
		

	def trackItemToPlay(self):
		return self.libraryView.trackItemToPlay()

	def canPlay(self):
		return True

	def canBurn(self):
		return False
	
	def canShowLocation(self):
		return True

	def play(self):
		self.libraryView.play()

	def getMultiInfoForTrackIDs(self,trackIDs):
		self.libraryView.getMultiInfoForTrackIDs(trackIDs)

	def getSummary(self):
		return self.libraryView.getSummary()

	def changed(self):
		self.emit(PYSIGNAL("changed"),(self,None))
	
	def canShowCurrent(self):
		return True

	def showSongItemForTrack(self,track):
		self.libraryView.showSongItemForTrack(track)

