#
# "@(#) $Id: LLibraryView.py,v 1.21 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from Library import *
from LLibraryViewItem import *
from LTrackDrag import *
from LTrackView import *
from LSettings import *
from LMultipleDrag import *
from LRemoteTrackDrag import *
from LRemotePlaylistDrag import *
import random,time
from utils import *
#import traceback

def removeDuplicates(items):
	result = {}
	for item in items:
		result[item] = 1
	return result.keys()

def cleanup(fileList):
	#print "cleanup",fileList
	files = []
	for file in fileList:
		files.append(unikode(file).encode('ISO-8859-1'))
	return files

class LLibraryView(LTrackView,KListView):
	def __init__(self,container,name='library'):
		LTrackView.__init__(self)
		KListView.__init__(self,container,name)
		self.settings = LSettings.settings()
		self.bulkEdit = False
		self.library = Library.mainLibrary()
		self.setCurrentPlaylist()
		self.setSelectionMode(QListView.Extended)
		self.setAllColumnsShowFocus(True)
		self.loadHeaders()
		c = QColor(237,243,254)
		self.setAlternateBackground(c)
		try: self.setShareSortColumn(True) # if KDE 3.4
		except: pass
##~ 		self.searchType = 'all'
##~ 		self.searchText = ''
		self.currentArtists = None
		self.currentAlbums = None
##~ 		self.loadArtistsAndAlbums()
		self.setAcceptDrops(True)
		self.setDropHighlighter(True)
		self.setDropVisualizer(False)
		QObject.connect(self,SIGNAL("clicked(QListViewItem *, const QPoint &, int)"),self.clickedItemColumnPoint)
		QObject.connect(self,SIGNAL("selectionChanged()"),self.doSelectionChanged)
		QObject.connect(self,SIGNAL("contextMenuRequested(QListViewItem *, const QPoint &, int)"),self.contextMenu)
		self.library.connect(PYSIGNAL("bulkEditBegin"),self.bulkEditBegin)
		self.library.connect(PYSIGNAL("bulkEditEnd"),self.bulkEditEnd)

	def bulkEditBegin(self):
		self.bulkEdit = True
	
	def bulkEditEnd(self):
		self.bulkEdit = False
		#self.loadTracks()

	def setCurrentPlaylist(self):
		self.playlistName = "Library"
		self.playlist = self.library.playlistWithName(self.playlistName)
		self.playlist.connect(PYSIGNAL("addedTrack"),self.addedTrack)
		self.playlist.connect(PYSIGNAL("removedTrack"),self.removedTrack)
	
	def loadHeaders(self):
		headers = [" ",i18n("Song Name"),i18n("Time"),i18n("Artist"),i18n("Album"),i18n("Genre"),i18n("My Rating"),i18n("Play Count"),i18n("Last Played")]
		widths = [40,220,40,120,180,80,80,70,130]
		for index in xrange(0,len(headers)):
			self.addColumn(headers[index],widths[index])
		self.setShowSortIndicator(True)
		self.setFullWidth(True)
		self.setColumnAlignment(7,Qt.AlignCenter)
		self.ratingColumn = 6
		sortColumn = self.settings.get('Main Library Sort Column',3)
		sortAscending = self.settings.get('Main Library Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)
		QObject.connect(self.header(),SIGNAL("indexChange(int,int,int)"),self.columnIndexChanged)
		QObject.connect(self.header(),SIGNAL("sizeChange(int,int,int)"),self.columnSizeChanged)
		self.loadHeaderSizes('Main Library Header Widths')
		self.loadHeaderOrdering('Main Library Header Map')

	def loadPlaylist(self,playlistName):
		playlist = self.library.playlistWithName(playlistName)
		self.setPlaylist(playlist)

	def loadTrackItem(self,track):
		item = LLibraryViewItem(self,track)


	def loadArtistsAndAlbums(self,artists=None,albums=None):
		start = time.time()
		self.currentArtists = artists
		if artists:
			self.currentArtists = map(lambda artist:artist.upper(),artists)
		self.currentAlbums = albums
		if albums:
			self.currentAlbums = map(lambda album:album.upper(),albums)
		end = time.time()
		#print "LLibraryView: computing artists and albums in",end-start,"seconds"
		self.loadTracks()

	def trackMatches(self,track):
#~ 		if self.currentArtists!=None:
##~ 			for artist in self.currentArtists:
##~ 				print type(artist)
		artist = None
		album = None
		if track.artist!=None: artist = unikode(track.artist)
		if track.album!=None: album = unikode(track.album)
		if self.currentArtists==None or len(self.currentArtists)==0 or (artist!=None and artist.upper() in self.currentArtists):
			if self.currentAlbums==None or len(self.currentAlbums)==0 or (album!=None and album.upper() in self.currentAlbums):
				if self.matchesSearch(track):
						return True
		return False
	
	def addedTrack(self,library,trackID):
		if not self.bulkEdit:
			track = self.library.trackWithTrackID(trackID)
			if self.trackMatches(track):
				self.loadTrackItem(track)
			self.emitCurrentEnabledSortedTracks()
			self.emit(PYSIGNAL("changed"),(self,None))

	def removedTrack(self,library,trackID):
		#print "LLibraryView removed track",trackID
		if not self.bulkEdit:
			track = library.trackWithTrackID(trackID)
			item = self.firstChild()
			while item:
				if item.track()==track:
					self.takeItem(item)
					del item
					break
				item = item.itemBelow()
			self.emitCurrentEnabledSortedTracks()
			self.emit(PYSIGNAL("changed"),(self,None))
		
	def loadTracks(self):
		#traceback.print_stack()
		#print "loading tracks for",self.currentArtists,self.currentAlbums
		start = time.time()
		playlist = self.library.playlistWithName("Library")
		tracks = playlist.tracks
		items = []
		for track in tracks:
			if track and self.trackMatches(track):
				items.append(track)
		sortColumn = self.settings.get('Main Library Sort Column',3)
		sortAscending = self.settings.get('Main Library Sort Ascending',True)
		#print "loading tracks in library"
		self.clear()
		self.setUpdatesEnabled(False)
		self.blockSignals(True)
		self.setSorting(-1,True)
		for track in items:
			if track: self.loadTrackItem(track)
		self.setSorting(sortColumn,sortAscending)
		self.blockSignals(False)
		self.setUpdatesEnabled(True)
		self.update()
		end = time.time()
		#print "LLibraryView loaded in",end-start,"seconds"
		self.emit(PYSIGNAL("changed"),(self,None))

	def refresh(self):
		self.loadArtistsAndAlbums(self.currentArtists,self.currentAlbums)

	def printFormats(self,event):
		print("formats:")
		n = 0
		while True:
			format = event.format(n)
			if (format==None):
				break
			print("  "+str(format))
			n = n+1
	
	def contentsMouseDoubleClickEvent(self,event):
		pos = self.contentsToViewport(event.pos())
		item = self.itemAt(pos)
		if item:
			item.contentsMouseDoubleClickEvent(event)

	#
	# drop methods used by Qt
	#
	def contentsDragEnterEvent(self,event):
		if QUriDrag.canDecode(event):
			uris = QStringList()
			if QUriDrag.decodeLocalFiles(event,uris):
				uris = cleanup(uris)
				if self.library.canImportFiles(uris):
					event.accept(True)

	def contentsDropEvent(self,event):
		if LRemoteTrackDrag.canDecode(event):
			print "dropped remote drag on library"
			return
		uris = QStringList()
		if QUriDrag.decodeLocalFiles(event,uris):
			uris = cleanup(uris)
			self.library.importFiles(removeDuplicates(uris),None)

	#
	# drop methods used by KDE
	#	
	def acceptDrag(self,event):
		if LRemoteTrackDrag.canDecode(event): return True
		if QUriDrag.canDecode(event): return True
			# XXX DSM removed due to Qt bug
##~ 			uris = QStringList()
##~ 			if QUriDrag.decodeLocalFiles(event,uris):
##~ 				uris = cleanup(uris)
##~ 				if self.library.canImportFiles(uris):
##~ 					return True
		return False
	
	def anyItemsSelected(self):
		item = self.firstChild()
		while item:
			if item.isSelected():
				return True
			item = item.itemBelow()
		return False

	def selectedTrackIDs(self):
		result = []
		item = self.firstChild()
		while item:
			if item.isSelected():
				result.append(item.trackID())
			item = item.itemBelow()
		return result

	def selectedTracks(self):
		result = []
		item = self.firstChild()
		while item:
			if item.isSelected():
				result.append(item.track())
			item = item.itemBelow()
		return result

	def selectedItems(self):
		result = []
		item = self.firstChild()
		while item:
			if item.isSelected():
				result.append(item)
			item = item.itemBelow()
		return result
	
	def firstSelectedItem(self):
		items = self.selectedItems()
		if len(items)>0:
			return items[0]
		return None

	def selectAll(self,select):
		KListView.selectAll(self,select)
##~ 		item = self.firstChild()
##~ 		while item:
##~ 			if item.isSelected()!=select:
##~ 				self.setSelected(item,select)
##~ 			item = item.itemBelow()
##~ 		#self.repaint()

	def removeSelectedItems(self):
		trackIDs = self.selectedTrackIDs()
		self.playlist.removeTrackIDs(trackIDs)
		trash = self.library.playlistWithName('Trash')
		if trash:
			trash.addTrackIDs(trackIDs)
	
	def dragObject(self):
		#print "dragging object"
		selectedTracks = self.selectedTrackIDs()
		tracks = self.library.tracksWithTrackIDs(selectedTracks)
		locations = [track.location for track in tracks]
		drag = LMultipleDrag(self)
		self.tdrag = LTrackDrag(selectedTracks,self.playlist,None)
		drag.addDragObject(self.tdrag)
		self.udrag = QUriDrag(locations)
		drag.addDragObject(self.udrag)
#		drag = LTrackDrag(selectedTracks,self.playlist,self)
		drag.dragCopy()

	def copySelectionToPlaylist(self,playlist):
		items = self.selectedTrackIDs()
		playlist.addTrackIDs(items)

	def setSearchType(self,searchType):
		self.searchType = searchType
		self.loadTracks()

	def setSearchText(self,searchText):
		self.searchText = searchText
		self.loadTracks()

	def xrandomItem(self):
		count = self.childCount()
		r = random.Random()
		index = r.randint(0,count-1)
		item = self.firstChild()
		while item and index:
			item = item.itemBelow()
			index = index-1
		return item

	def xtrackItemToPlay(self):
		items = self.selectedItems()
		if len(items)==0:
			# XXX DSM exclude items checked off
			items = [self.randomItem()]
		return items[0]

	def play(self):
		item = self.firstSelectedItem()
		if item:
			#print "playing selected item"
			item.track().play(self.playlist)
		else:
			#print "playing some item"
			LMusicPlayer.playItemFrom(self.library,self.playlist)
	
	def clickedItemColumnPoint(self,item,point,column):
		if item and column==self.ratingColumn:
			r = self.itemRect(item)
			point = self.mapFromGlobal(point)
			px = point.x()
			px = px-self.header().sectionPos(column)-3 # XXX DSM fudge out width of frame??
			point = self.viewportToContents(QPoint(px,point.y()))
			px = point.x()
			#print "clicked",item,"column",column,"at",px
			item.clickedRatingAt(px)

	def setSorting(self,column,ascending = True):
		KListView.setSorting(self,column,ascending)
		self.settings['Main Library Sort Column'] = column
		self.settings['Main Library Sort Ascending'] = not not ascending
		self.emitCurrentEnabledSortedTracks()

	def doSelectionChanged(self):
		if self.anyItemsSelected():
			LMusicPlayer.selectedTrack()
	
	def clear(self):
		item = self.firstChild()
		while item:
			item.die()
			item = item.itemBelow()
		KListView.clear(self)
	
	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('Main Library Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('Main Library Header Widths')

	def contextMenu(self,item,pos,col):
		if item:
			item.contextMenu(pos,col)

	def createArtistPlaylist(self,artist):
		trackIDs = self.library.playlistWithName('Library').trackIDsForArtists([artist])
		self.library.addPlaylistFromTrackIDs(trackIDs)
	
	def createAlbumPlaylist(self,album):
		trackIDs = self.library.playlistWithName('Library').trackIDsForAlbums([album])
		self.library.addPlaylistFromTrackIDs(trackIDs)
	
	def canShowCurrent(self):
		return True

	def rename(self,item,column):
		KListView.rename(self,item,column)
		#print "about to rename",item,column
		completion = self.renameLineEdit().completionObject()
		completion.clear()
		if column==item.artistColumn:
			#print "setting artist completion"
			for artist in self.library.artists():
				completion.addItem(artist)
		elif column==item.albumColumn:
			#print "setting album completion"
			for album in self.library.albums():
				completion.addItem(album)
