#
# LLibrarySourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LPlaylistSourceViewItem import *
from LTrackDrag import *
from LDellTrackDrag import *
from LPodTrackDrag import *

#
# Master library playlist
#
class LLibrarySourceViewItem(LPlaylistSourceViewItem):
	def __init__(self,container,source):
		LPlaylistSourceViewItem.__init__(self,container,source)
		self.setRenameEnabled(0,False)
		self.wantsTrackDrags = True
		self.canExport = True
		self.setText(0,i18n("Media Library"))
		self.setDragEnabled(False)

	def makeKey(self):
		return 'A'

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		id = self.popup.insertItem(i18n("Export Song List"),mainWindow.slotExportLibrary)

	def loadPopup(self):
		pass

	def iconFileName(self): return "sourcelibrary.png"

	def select(self,container):
		container.emit(PYSIGNAL("selectLibrary"),(None,None))

	#
	# allow file system drags
	# allow track drags from the trash only
	#
	def acceptDrag(self,event):
		if not self.wantsTrackDrags: return False
		elif self.wantsFileDrags and QUriDrag.canDecode(event): return True
		elif LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			playlist = self.library.playlistWithName(drag['Playlist'])
			if playlist==self.trash: return True
		elif LDellTrackDrag.canDecode(event):
			return True
		elif LPodTrackDrag.canDecode(event):
			return True
		elif LRemoteTrackDrag.canDecode(event):
			return True
		return False

	#
	# handle file system drags
	# and track drags if source is the trash
	#
	def dropped(self,event):
		#self.printDragFormats(event)
		if LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			#print "library got",drag
			playlist = self.library.playlistWithName(drag['Playlist'])
			trackIDs = drag['TrackIDs']
			if playlist == self.trash:
				self.libraryPlaylist.addTrackIDs(trackIDs)
				self.trash.removeTrackIDs(trackIDs)
		elif LDellTrackDrag.canDecode(event):
			from DellLibrary import DellLibrary
			from LMusicDellManager import LMusicDellManager
			drag = LDellTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			tracks = DellLibrary.singleton().tracksWithTrackIDs(trackIDs)
			#print "library accepting Dell",tracks
			LMusicDellManager.singleton().downloadTracksToPlaylist(None,tracks)
		elif LPodTrackDrag.canDecode(event):
			from PodLibrary import PodLibrary
			from LMusicPodManager import LMusicPodManager
			drag = LPodTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			tracks = PodLibrary.singleton().tracksWithTrackIDs(trackIDs)
			LMusicPodManager.singleton().downloadTracksToPlaylist(None,tracks)
		elif LRemoteTrackDrag.canDecode(event):
			drag = LRemoteTrackDrag.decode(event)
			tracks = []
			for trackplist in drag['Tracks']:
				track = Track()
				track.setPList(trackplist)
				tracks.append(track)
			LMusicDownloader.singleton().downloadTracks(tracks,None,self.library)
		elif QUriDrag.canDecode(event):
			uris = QStringList()
			if QUriDrag.decodeLocalFiles(event,uris):
				self.library.importFiles(removeDuplicates(uris),None)

	def doubleClick(self):
		pass
