#
# "@(#) $Id: LFunctionWidget.py,v 1.5 2004/07/26 16:46:23 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LMultiPushButton import *
from LsongsPaths import *

class LFunctionWidget(QWidget):
	def __init__(self,container = None):
		QWidget.__init__(self,container)
		self.buildControls()

	def buildControls(self):
		layout = QVBoxLayout(self)
		iconbrowse = QIconSet(QPixmap(art("buttonbrowse.png")))
		iconburnoff = QIconSet(QPixmap(art("buttonburnoff.png")))
		iconburnon = QIconSet(QPixmap(art("buttonburnon.png")))
		iconoptions = QIconSet(QPixmap(art("buttonoptions.png")))
		iconrefresh = QIconSet(QPixmap(art("buttonrefresh.png")))
		iconimport = QIconSet(QPixmap(art("buttonimport.png")))
		iconsync = QIconSet(QPixmap(art("buttonimport.png")))
		self.functionButton = LPixmapMultiPushButton("",self)
		layout.addWidget(self.functionButton)
		self.label = QLabel("",self)
		self.label.setAlignment(Qt.AlignCenter)
		layout.addWidget(self.label)
		QObject.connect(self.functionButton,PYSIGNAL("setState"),self.changeState)
		self.functionButton.addState('browse',iconbrowse,PYSIGNAL('browse'),None,i18n("Browse"))
		self.functionButton.addState('burnoff',iconburnoff,PYSIGNAL('burnEnable'),None,i18n("Burn"))
		self.functionButton.addState('burnon',iconburnon,PYSIGNAL('burn'),None,i18n("Burn"))
		self.functionButton.addState('options',iconoptions,PYSIGNAL('options'),None,i18n("Options"))
		self.functionButton.addState('refresh',iconrefresh,PYSIGNAL('refresh'),None,i18n("Refresh"))
		self.functionButton.addState('import',iconimport,PYSIGNAL('import'),None,i18n("Import"))
		self.functionButton.addState('sync',iconsync,PYSIGNAL('sync'),None,i18n("Sync"))
		QObject.connect(self.functionButton,PYSIGNAL('browse'),self.slotBrowse)
		QObject.connect(self.functionButton,PYSIGNAL('burnEnable'),self.slotBurnEnable)
		QObject.connect(self.functionButton,PYSIGNAL('burn'),self.slotBurn)
		QObject.connect(self.functionButton,PYSIGNAL('options'),self.slotOptions)
		QObject.connect(self.functionButton,PYSIGNAL('refresh'),self.slotRefresh)
		QObject.connect(self.functionButton,PYSIGNAL('import'),self.slotImport)
		QObject.connect(self.functionButton,PYSIGNAL('sync'),self.slotSync)

	def changeState(self,button,state,label):
		self.label.setText(label)

	def slotBrowse(self):
		self.emit(PYSIGNAL('browse'),(self,None))
	
	def slotBurnEnable(self):
		self.emit(PYSIGNAL('burnEnable'),(self,None))
	
	def slotBurn(self):
		self.emit(PYSIGNAL('burn'),(self,None))
	
	def slotOptions(self):
		self.emit(PYSIGNAL('options'),(self,None))
		
	def slotRefresh(self):
		self.emit(PYSIGNAL('refresh'),(self,None))
	
	def slotImport(self):
		self.emit(PYSIGNAL('import'),(self,None))
	
	def slotSync(self):
		self.emit(PYSIGNAL('sync'),(self,None))

	def setState(self,state):
		self.functionButton.setState(state)
