#
# "LDeviceTrackViewItem.py"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LCheckListViewItem import *
from LTrackViewItemObject import *
from LsongsPaths import *
from human import *
import time

def _get(a,b):
	if a==None: return b
	return a

_playingIcon = None
def playingIcon():
	global _playingIcon
	if _playingIcon==None:
		_playingIcon = QPixmap(art("labelcurrentplaying.png"))
	return _playingIcon

_pausedIcon = None
def pausedIcon():
	global _pausedIcon
	if _pausedIcon==None:
		_pausedIcon = QPixmap(art("labelcurrentpause.png"))
	return _pausedIcon

class LDeviceTrackViewItem(KListViewItem):
	def __init__(self,container,track,index):
		KListViewItem.__init__(self,container)
		self.index = index
		self._track = track
		self.trackItem = LTrackViewItemObject(self)
		self.status = 'idle'
		self.ripIcon = -1
		self.ripTime = -1
		self.titleColumn = 1
		self.durationColumn = 2
		self.artistColumn = 3
		self.albumColumn = 4
		self.genreColumn = 5
		self.loadTrackInfo()
		self.setDragEnabled(True)

	def setIndex(self,index):
		self.index = index

	def die(self):
		self.trackItem.trackItem = None
		self.trackItem = None

	def track(self):
		return self._track

	def trackID(self):
		return self._track.trackID

	def loadTrackInfo(self):
		self.setText(self.titleColumn,_get(self._track.title,""))
		self.titleKey = QString(self._track.titleKey())

		self.setText(self.durationColumn,humanDuration(self._track.totalTime))
		self.durationKey = QString(self._track.durationKey())
		
		self.setText(self.artistColumn,_get(self._track.artist,""))

		self.setText(self.albumColumn,_get(self._track.album,""))

		self.albumKey = unikode(self._track.albumKey())+self._track.durationKey()
		self.artistKey = unikode(self._track.artistKey())+unikode(self.albumKey)
		self.artistKey = QString(self.artistKey)
		self.albumKey = QString(self.albumKey)

		self.genreKey = _get(self._track.genre,"")
		self.setText(self.genreColumn,self.genreKey)
		self.genreKey = QString(self.genreKey)
		
		self.setPlayingIcon()

	def key(self,column,ascending):
		try:
			if column==self.titleColumn:
				return self.titleKey
			elif column==self.durationColumn:
				return self.durationKey
			elif column==self.artistColumn:
				return self.artistKey
			elif column==self.albumColumn:
				return self.albumKey
			elif column==self.genreColumn:
				return self.genreKey
		except: pass
		return "0"

	def contentsMouseDoubleClickEvent(self,event):
		self.play()

	def play(self):
		playlist = self.listView().playlist
		self._track.play(playlist)

	def doImport(self):
		self._track.doImport()
	
	def stateChange(self,value):
		self._track.enabled = bool(value)

	def changedAttribute(self,attribute,oldValue,newValue):
		if attribute in ['trackNum','title','artist','album','contentType','playStatus']:
			self.loadTrackInfo()
		
	def setIdleIcon(self):
		self.setPixmap(0,QPixmap())

	def setPlayingIcon(self):
		status = self._track.playStatus
		if self.status!=status:
			if status=='playing':
				self.setPixmap(0,playingIcon())
			elif status=='paused':
				self.setPixmap(0,pausedIcon())
			else:
				self.setPixmap(0,QPixmap())
			self.status = status
		
	def contextMenu(self,pos,col):
		pass
