#
# LDellPlaylistSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from LSourceViewItem import *
from LDellPlaylistDrag import *
from LTrackDrag import *
from LDellTrackDrag import *
from LMusicDellManager import *
from utils import *
#
# Dell playlist (individual)
#
class LDellPlaylistSourceViewItem(LSourceViewItem):
	def __init__(self,container,playlist):
		self.playlist = playlist
		self.name = playlist.name
		LSourceViewItem.__init__(self,container,self.name)
		self.hasContextMenu = False
		self.setDragEnabled(True)
		self.setDropEnabled(True)
		self.setRenameEnabled(0,True)
		self.playlist.connect(PYSIGNAL("renamed"),self.changedName)
	
	def changedName(self,playlist,oldName,newName):
		self.setText(0,newName)

	def makeKey(self):
		if self.playlist.master: return "A"
		else: return u'B %s'+unikode(self.name)

	def iconFileName(self):
		if self.playlist.master: return "sourcelibrary.png"
		else: return "sourceplaylist.png"

	def changeName(self,newName):
		self.playlist.setName(newName)
		self.buildKey()

	def buildPopup(self,mainWindow):
		pass

	def select(self,container):
		container.emit(PYSIGNAL("selectDellPlaylist"),(self.playlist,None))

	def createDrag(self,container):
		return LDellPlaylistDrag(self.playlist,container)
		pass

	def acceptDrag(self,event):
		if LTrackDrag.canDecode(event): return True
		if LDellTrackDrag.canDecode(event) and not self.playlist.master: return True
		return False
	
	def dropped(self,event):
		if LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			library = Library.mainLibrary()
			trackIDs = drag['TrackIDs']
			tracks = library.tracksWithTrackIDs(trackIDs)
			tracks = filter(lambda track: track.kind.startswith('MPEG audio file'),tracks)
			if len(tracks)>0:
				#print "LDellPlaylistSourceViewItem.dropped accepting tracks",tracks
				LMusicDellManager.singleton().uploadTracksToPlaylist(self.playlist,tracks)
			return
		if LDellTrackDrag.canDecode(event):
			print "DellPlaylistSourceView:got LDellTrackDrag"
			drag = LDellTrackDrag.decode(event)
			print "decoded to",drag
			if self.playlist.name!=drag['Playlist']: # make sure coming from different playlist
				print "adding tracks"
				LMusicDellManager.singleton().addTrackIDsToPlaylist(self.playlist,drag['TrackIDs'])
