from qt import *
from kdeemul import *
import socket
from Library import Library
from LSettings import *

class LDAAPServer(KProcess):
	def __init__(self,name):
		KProcess.__init__(self)
		self.name = name
		QObject.connect(self,SIGNAL("processExited(KProcess *)"),self.endProcess)
		QObject.connect(self,SIGNAL("receivedStdout(KProcess *,char *,int)"),self.gotOutput)
		QObject.connect(self,SIGNAL("receivedStderr(KProcess *,char *,int)"),self.gotError)
		self.setExecutable("nice")
		args = ["daapd","-x",Library.mainLibrary().xmlPath(),'-n',self.name,'-s','60']
		if LSettings.settings().get('Share All',False):
			args.append('-a')
		self.setArguments(args)
		print "starting DAAP server"
		self.start(KProcess.NotifyOnExit,KProcess.AllOutput)
		print "started DAAP server"
	
	def gotOutput(self,process,buffer,bufferlen):
		#print "DAAP:output",buffer
		pass

	def gotError(self,process,buffer,bufferlen):
		#print "DAAP:error:",buffer
		pass

	def endProcess(self,process):
		pass
		#print "DAAP:end"

	def killTasks(self):
		print "killing DAAP server"
		self.kill(15)
		print "killed"
