#
# "@(#) $Id: DellTrack.py,v 1.4 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from Track import *
from LMusicPlayer import *
from LsongsDevices import *
import time, re, os

def tr(str,trans):
	res = ''
	for c in str:
		if trans.has_key(c): res = res+trans[c]
		else: res = res+c
	return res

class DellTrack(Track):
	def __init__(self,library = None):
		Track.__init__(self,library)
		self.kind = "Dell Track"
		self.location = "njb:/1"
		self.njb = None
		if library: self.setDevice(library.njb)

	def play(self,playlist = None):
		pass
		#LMusicPlayer.playTrack(self,self._library,playlist)

	def setDevice(self,njb):
		self.njb = njb

	def cleanup(self,s):
		return tr(s,{'/':'-',' ':'_',':':'_','\\':'_','<':'(','>':')',';':'_','|':'_'})

	def fromSong(self,song):
		self.trackID = song.GetTrackID()
		#print "parsing song",self.trackID
		song.ResetGetFrame()
		frame = song.GetFrame()
		while frame:
			label = frame.GetLabel()
			value = frame.GetValue()
			#print "   ",label,value
			if label=='TITLE':
				self.title = value
				self.originalLocation = self.cleanup(value)+".mp3"
			elif label=='ARTIST': self.artist = value
			elif label=='ALBUM': self.album = value
			elif label=='FILE SIZE': self.size = value
			elif label=='LENGTH': self.totalTime = value*1000
			elif label=='GENRE': self.genre = value
			elif label=='YEAR' and value>1900: self.year = value
			elif label=='TRACK NUM': self.trackNum = value
			elif label=='FNAME': self.originalLocation = value
			frame = song.GetFrame()
		#print "DellTrack, imported ",self.originalLocation
		self.kind = "MPEG audio file"

	def download(self,callback = None, data = None):
		tmpPath = os.environ.get('TMP','/tmp')
		#print "tmpPath",tmpPath,"location",self.originalLocation
		path = os.path.join(tmpPath,self.originalLocation)
		#print "downloading track to",path,"of size",self.size
		self.njb.GetTrack(self.trackID,self.size,path,callback,data)
		return path

