// $Id: installreffile.cpp,v 1.27 2006/05/12 20:31:23 hvengel Exp $
//  Little cms - profiler construction set
//Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//


#include "installreffile.h"
#include <lprofmain.h>
#include <qtlcmswidgets.h>
#include <qurloperator.h>
#include <qmutex.h>

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif


// static ref_file_parms dirs;
// static targetTemplate files;
// static QAssistantClient* help

static QMutex mutex;

QString inst_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}


InstallRefFile::InstallRefFile(QWidget *parent) 
    :InstallRefFileBase(parent), urlOp("/")
{
    QString temp;
    
    ref_file a;
    a.get(a);
    dirs = a.items;
    SelectTemplate->Dir = dirs.temp_dir;
    SelectTemplate->FillValues();
    SelectTemplate->setCurrItem(0);
    TargetSelector->Dir=dirs.home_dir;
    TargetSelector->setFilename("");
    connect( &urlOp, SIGNAL( finished( QNetworkOperation *) ), this, SLOT( slotFileCopied( QNetworkOperation * ) ) );

    // gray OK button
    buttonOk -> setEnabled(FALSE);
    copyNum=0;
    // mutex = new QMutex(false);
    
}

InstallRefFile::~InstallRefFile()
{
//     help -> ~QAssistantClient();
    dialogSize ds;
        
    ds.put(1, this -> height(), this -> width());
}


void InstallRefFile::slotFileCopied( QNetworkOperation *op )
{
    QString errorInfo;
    qDebug("InstallRefFile::slotFileCopied()");
    mutex.lock();
    if ( !op )
        return;

    if ( op && op->state() == QNetworkProtocol::StFailed ) {
        // an error happend, let the user know that

        // enable this after realease of 1.11.4
        // QMessageBox::critical( this, tr( "ERROR" ), op->protocolDetail() );
        // untill then just use qDebug so that developers
        // can see what is happening 
        qDebug("File copy operation done - it has failed");
        qDebug(errorInfo.sprintf("The error code is %i", op->errorCode()));
    } else qDebug("File saved - operation successful.");
    copyNum = copyNum - 1;
    if (copyNum < 1)
        buttonCancel->setEnabled(true);
    mutex.unlock();
}

void InstallRefFile::slotOK()
{   
    mutex.lock();
    copyNum = copyNum + 1;
    // pull file names out of the dialog
    buttonCancel->setEnabled(false);
    files.items.templateFile=SelectTemplate->getFilename();

    files.items.targetFile = dirs.ref_dir + 
            TargetSelector->getFilename().mid(TargetSelector->Dir.length(),
            TargetSelector->getFilename().length());

    QDir::cleanDirPath( files.items.targetFile );

    // copy the reference file to ~/.lprof/target_refs
    urlOp.copy( TargetSelector->getFilename(), dirs.ref_dir + (QString) "/");
    mutex.unlock();
    
    // pass new reference file/template info back to main dialog
    files.put(files);
    
    dialogSize ds;
        
    ds.put(1, this -> height(), this -> width());
}

void InstallRefFile::slotCancel()
{
    dialogSize ds;
    
    ds.put(1, this -> height(), this -> width());
}

void InstallRefFile::slotValueChanged()
{
     // qDebug("slotValueChanged install ref file");
     // if both selectors have a value ungray OK button
     if (TargetSelector->getFilename() != "" && SelectTemplate -> getFilename() != "")
         buttonOk -> setEnabled(TRUE);
}

void InstallRefFile::slotHelpButton()
{   
     QString path = QDir::currentDirPath() + "/help/inst-ref.html";
     getHelp()->openAssistant ();
     getHelp()->showPage(path);
}
