Summary: LPRngTool is a printer configuration and print queue monitoring and management utility with a graphical user interface for LPRng.
Name: LPRngTool
Version: 1.3.2
Release: 1
Copyright: GPL
Group: Applications/Publishing
Source: LPRngTool-%{PACKAGE_VERSION}.tgz
Requires: ghostscript tcl tk >= 1.50 LPRng >= 3.7  ifhp >= 3.4
Provides: LPRngTool
Obsoletes: printtool
BuildArchitectures: i386
BuildRoot: /tmp/lprngtool

%define wmconfig /etc/X11/wmconfig
%define bindir /usr/bin
%define controlpanel /usr/lib/rhs/control-panel
%define filterdir /usr/libexec/filters
%define sysconfdir /etc
%define mandir /usr/share/man
%define datadir /usr/share

%description
LPRngTool is a printer configuration and print queue monitoring
and management utility with a graphical user interface.  LPRngTool is
similar to Red Hat's 'printtool', but includes most of the additional
functions of LPRng (including printer pooling, printer redirection, job
accounting, etc), and the 'lpc' facilities for local and remote queue
management and monitoring.  LPRngTool works with SMB, Windows, HP
JetDirect, locally-attached, and unfiltered printers and print queues.

%prep
%setup

%build

# configuration for Linux
CONFIGURE_ARGS="--bindir=%{bindir} --mandir=%{mandir} \
	--with-lprngtool_conf=%{sysconfdir}/lprngtool.conf \
	--with-printcap_path=%{sysconfdir}/printcap \
	--with-spool_directory=/var/spool/lpd  \
	--with-filterdir=%{filterdir} \
	--with-ifhp_path=%{filterdir}/ifhp \
	--with-gsupdir=%{datadir}/ghostscript"

CFLAGS=$RPM_OPT_FLAGS ./configure ${CONFIGURE_ARGS}
make

%install
rm -rf %{buildroot}
mkdir -p $RPM_BUILD_ROOT/%wmconfig
mkdir -p $RPM_BUILD_ROOT/%bindir
mkdir -p $RPM_BUILD_ROOT/%controlpanel
mkdir -p $RPM_BUILD_ROOT/%filterdir
mkdir -p $RPM_BUILD_ROOT/%sysconfdir
rm -rf $RPM_BUILD_ROOT/%mandir/man1
mkdir -p $RPM_BUILD_ROOT/%mandir/man1

make DESTDIR=$RPM_BUILD_ROOT install

install lprngtool.wmconfig -m 644 $RPM_BUILD_ROOT/%wmconfig/lprngtool  
install lprngtool.init -m 644 $RPM_BUILD_ROOT/%controlpanel/lprngtool.init
install lprngtool.xpm  -m 644 $RPM_BUILD_ROOT/%controlpanel/lprngtool.xpm

%clean

%changelog
* Mon Nov 27 2000 Patrick Powell <papowell@lprng.com>
- Updated the configuration methods.  Added checks, debugging,
  and modified configuration actions in light of experience with
  the tool.  Basically,  the whole thing was rewritten.

* Mon Oct 23 2000 Geoff Silver <geoff@uslinux.net>
- Added an /etc/lprngtool.conf file for global system configuration, to
allow alternative systems to work properly with LPRngTool.

* Mon Oct 16 2000 Geoff Silver <geoff@uslinux.net>
- Minor fix to pooling routine to specify "ss=".  Also, globalizes a
printerpool variable to determine how to set ss= variable.
        
* Mon Oct 16 2000 Geoff Silver <geoff@uslinux.net>
- Tried to make printer definitions a bit clearer when adding a printer.

* Thu Oct 12 2000 Geoff Silver <geoff@uslinux.net>
- Changed version numbering scheme.  First number is now a major release
number, second is the minor revision number, and the third is the patch
level.

* Thu Oct 12 2000 Geoff Silver <geoff@uslinux.net>
- Patched to work with RedHat 7.0, which uses user and group 'lp' as the
default /var/spool/lpd owner, instead of the standard daemon/daemon.

* Thu Oct 12 2000 Geoff Silver <geoff@uslinux.net>
- Changed filtering design.  The master-filter in filtersrcdir is no
longer copied to the individual spool directories.  This will prevent
breaking things when the master-filter is upgraded.

* Tue Oct 10 2000 Geoff Silver <geoff@uslinux.net>
- Added the ability to check if jobs are queued/printing in all queues on
a server, instead of checking each individually.

* Tue Oct 10 2000 Geoff Silver <geoff@uslinux.net>
- Updated installation script to backup lpd.perms file before overwriting
it, and to check if /usr/bin/printtool is already a symbolic link before
setting it.

* Tue Oct 10 2000 Geoff Silver <geoff@uslinux.net>
- Included rewindstdin.c source for use of filters on non-Linux systems,
and an installation check to notify the user that this is necessary if the
system is not Linux.

* Fri Sep 15 2000 Geoff Silver <geoff@uslinux.net>
- Minor fix to allow test printing to ANY lprng printer, instead of just
local printers.

* Fri Sep 15 2000 Geoff Silver <geoff@uslinux.net>
- Minor change to the installation script to link lpr -> lp if the lprng
installation for your system does not create it.

* Fri Sep  8 2000 Geoff Silver <geoff@uslinux.net>
- Initial Release

%files
%defattr(-,root,root)
%doc README CHANGES INSTALL
%{bindir}/*
%{controlpanel}/lprngtool.init
%{controlpanel}/lprngtool.xpm
%attr(0644,root,root)   %config            %{sysconfdir}/lprngtool.conf
%attr(0644,root,root)                      %{sysconfdir}/lprngtool.conf.sample
%attr(0644,root,root)	%config(missingok) %{wmconfig}/lprngtool
%{mandir}/man1/*.1*
%dir %filterdir
%{filterdir}/*
