#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>

#include "err.h"

#define BS 4096
#define FL 80

int
main(int argc,char * argv[]) {

  char c,b[BS],*bs,*be,*bp,f[FL];
  unsigned char s=0;
  int i,l,n,fn=0;
  pid_t p;

  i=-1;
  while ((c=getopt(argc,argv,"s:"))!=EOF) 
    switch(c) {
    case 's':
      i=atoi(optarg);
      if (i>0xff || i<0)
	errret("Bad separator %d\n",i);
      else
	s=i;
      break;
    default:
      errret("Usage: %s -s <sep char (ascii code)> files ...\n",argv[0]);
      break;
    }
  if (i==-1)
    errret("Usage: %s -s <sep char (ascii code)> files ...\n",argv[0]);
  
  argc-=optind-1;
  argv+=optind-1;

  p=getpid();
  if (snprintf(f,sizeof(f),"%d.%02d.g3",p,++fn)<0)
    errret("Can't make g3 filename\n");
  if ((l=open(f,O_CREAT|O_RDWR|O_TRUNC,0644))<0)
    error("Can't open %s for writing\n",f);
  
  for (;(n=read(0,b,sizeof(b)));) {
      
    for (bp=b,be=b+n;bp<be && (bs=memchr(bp,s,be-bp));bp=bs) {

      if (write(l,bp,bs-bp)!=bs-bp)
	errret("Can't write to %s\n",f);

      if (bs+1<be) 
	c=bs[1];
      else {
	if (read(0,&c,sizeof(c))!=sizeof(c)) {
	  if (close(l))
	    errret("Can't close %s\n",f);
	  return 0;
	}
      }
      if (c!=s) {
	if (close(l))
	  errret("Can't close %s\n",f);
	if (snprintf(f,sizeof(f),"%d.%02d.g3",p,++fn)<0)
	  errret("Can't make g3 filename\n");
	if ((l=open(f,O_CREAT|O_RDWR|O_TRUNC,0644))<0)
	  errret("Can't open %s for writing\n",f);
      }
      if (write(l,&c,sizeof(c))!=sizeof(c))
	errret("Can't write c to l\n");
      bs+=2;
    }
	
    if (write(l,bp,be-bp)!=be-bp)
      errret("Can't write end block\n");

  }

  return 0;

}


