/* Copyright (C) 2000/2002 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _LOG_H_
#define _LOG_H_

#define LOG_OTHER        0
#define LOG_MESSAGE      1
#define LOG_CHANNEL      2
#define LOG_PRIVATE      3
#define LOG_OPERATOR     4
#define LOG_GLOBAL       5
#define LOG_PROTOCOL     6

struct net_t;

typedef struct {
  char *description;
  char *filename;
  FILE *fd;
  int type;
  long time;
} log_t;

void       l_log            (net_t* net, char *des, int type,
			     const char *fmt, ...);
void       close_logs       (net_t* net);
void       log_show_init    ();
void       log_show_exit    ();
void       log_show_network (GtkCList* clist, int row);
gint       log_updater      (gpointer data);
void       log_show_file    (GtkCList* clist, int row);
void       log_show_session (GtkCList* clist, int row);

GtkWidget* create_log_popup (GtkWidget* widget);
GtkWidget* create_log2_popup(GtkWidget* widget);

#endif
