<!-- Feuille de style pour SGML/Docbook pour la documentation Logtrend -->
<!-- Gre les backend html et ps/pdf -->
<!-- Version 1.2 - Frdric Dubuy - 30 octobre 2000 -->

<!-- Dfinition de la feuille de style et inclusion des feuilles de style
Docbook sur lesquelles on se base -->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY % entities SYSTEM "global.ent">
%entities;

<![ %output.html; [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
]]>
<![ %output.print; [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA DSSSL>
<!ENTITY titlepage.dsl  SYSTEM "titlepage.dsl">

]]>
]>

<style-sheet>
  <style-specification use="docbook">
    <style-specification-body>

<!-- ................................................................... -->
<!-- Partie concernant seulement le HTML ............................... -->
<!-- ................................................................... -->

<!-- Inclusion conditionnelle si la variable output.html vaut "INCLUDE"  -->
      
<![ %output.html; [


<!-- on dfinit l'entte des pages HTML -->

(define %html-header-tags% 
  ;; What additional HEAD tags should be generated?
	'(("META" ("NAME" "name")("LANG" "fr")
	("CONTENT" "LOGTREND - Documentation"))
	("META" ("NAME" "keywords")("lang" "fr")
	("CONTENT" "GNU, gpl, gnu, free, software, supervision, network, log,
	linux, apache, proftp, xml, html, graph, report" ))
	("META" ("http-equiv" "content-type")("CONTENT" "text/html;charset=iso-8859-1"))))


<!-- on dfinit les attributs du BODY -->

(define %body-attr% 
    (list
	  (list "BGCOLOR" "#FFFFCC")
      (list "TEXT" "#001111")
      (list "LINK" "#3333FF")
	  (list "VLINK" "#CC66CC")
	  (list "ALINK" "#FF0000")
	))



;; Utilisation des tables pour gnrer les liens en haut et bas de page ? 
;; #t : true, #f : false
(define %gentext-nav-use-tables% #t)

;; Extension par dfaut des fichiers html gnrs. 
(define %html-ext% ".html")

;; Est-ce que les environnements verbatim doivent tre ombrs
(define %shade-verbatim% #t)

<!-- utilisation des id comme nom de fichier (<chapter id=mon_chapitre>...</chapter) -->
(define %use-id-as-filename% #t)
 
;; Nom du fichier principal
(define %root-filename% "index")

;; Est-ce qu'on met un manifeste ?
(define html-manifest #f)


;; inclusion des callout-graphics tirs de la feuille de style freebsd.
    (define %callout-graphics%
    ;; Use graphics in callouts?
    #t)

    (define %callout-graphics-ext%
    ;; The extension to use for callout images.  This is an extension
    ;; to the stylesheets, they do not support this functionality
    ;; natively.
    ".png")

    (define %callout-graphics-path%
    ;; Path to callout graphics
    "./imagelib/callouts/")

    ;; Redefine $callout-bug$ to support the %callout-graphic-ext%
    ;; variable.
    (define ($callout-bug$ conumber)
	  (let ((number (if conumber (format-number conumber "1") "0")))
	    (if conumber
		(if %callout-graphics%
	       (if (<= conumber %callout-graphics-number-limit%)
	       (make empty-element gi: "IMG"
	       attributes: (list (list "SRC"
	                (root-rel-path
		            (string-append
			        %callout-graphics-path%
					number
	                %callout-graphics-ext%)))
		      (list "HSPACE" "0")
		      (list "VSPACE" "0")
		      (list "BORDER" "0")
		      (list "ALT"
			      (string-append
	                "(" number ")"))))
		   (make element gi: "B"
		      (literal "(" (format-number conumber "1") ")")))
	       (make element gi: "B"
		      (literal "(" (format-number conumber "1") ")")))
	       (make element gi: "B"
	          (literal "(??)")))))

<!-- Inclusion d'un lien email en bas de la page -->

(define ($email-footer$)
  (make sequence
	(literal "For more information, please contact ")
    (make element gi: "a"
	  	attributes: (list (list "href" "mailto:webmaster@logtrend.org?Subject=About Logtrend's documentation"))
		(literal "us"))))


(define ($html-body-end$)
  (if (equal? $email-footer$ (normalize ""))
     (empty-sosofo)
     (make sequence
        (make empty-element gi: "hr")
        (empty-sosofo)
        (make element gi: "p"
           attributes: (list (list "align" "center"))
           ($email-footer$)))))

<!-- Inclusion du logo Logtrend en haut de page -->

(define ($logtrend-header$)
  (make sequence
	  (make element gi: "a"
      attributes: (list (list "href" "http://www.logtrend.org"))
		(make element gi: "img"
			attributes: (list (list "src" "&logo;")(list "border" "0"))
			(empty-sosofo)))))
				
(define ($html-body-start$)
   (if (equal? $logtrend-header$ (normalize ""))
       (empty-sosofo)
       (make sequence
		  (make element gi: "p"
			  attributes: (list (list "align" "center"))
			  ($logtrend-header$))
              (make empty-element gi: "hr"))))

]]>
<!-- ................................................................... -->
<!-- Fin de la partie concernant seulement le HTML ..................... -->
<!-- ................................................................... -->


<!-- ................................................................... -->
<!-- Partie concernant seulement le postscript ......................... -->
<!-- ................................................................... -->


<!-- Inclusion conditionnelle si la variable output.print vaut "INCLUDE"  -->
<![ %output.print; [


<!-- Inclusion de la feuille de style pour la page de titre -->
&titlepage.dsl



;;famille de police utilise
(define %title-font-family% "Times New Roman")

;;famille de police utilise pour le corps du document
(define %body-font-family% "Times New Roman")

;;famille de police utilise pour les paragraphes particuliers
(define %admon-font-family% "Times New Roman")

;; nombre de colonnes dans le document
(define %page-n-columns% 1)

;; sortie recto seulement (un seul ct)
(define %two-side% #f)

;; papier A4
 (define %paper-type% "A4")

(define %visual-acuity%
  ;; Taille des polices : les choix suivants existent 
  ;; "tiny"
  ;; "presbyopic"
  ;; "large-type"
   "normal")

;; facteur multiplicatif de la taille des polices (taille_titre =
;; 5xbump-factorxtaille_du_corps)
(define %hsize-bump-factor% 1.08)

;; espace minimum entre 2 lignes
(define %min-leading% 2pt)

;; est-ce que le nom du chapitre apparait en haut de la page ?
(define %chap-app-running-heads% #t)
(define %chap-app-running-head-autolabel% #t)

;; on ne veut pas de liste des tables
(define %generate-book-lot-list% #f)


;;est-ce que les URL apparaissent en tant que note de bas de page ?
(define %footnote-ulinks% #f)

;;Est-ce que les notes de bas de pages apparaissent sur la page 
(define %bop-footnotes% #f)

;; indentation du corps de texte
(define %body-start-indent% 0pi)

;; indentation de la 1ere ligne du premier paragraphe
(define %para-indent-firstpara% 0pt)

;; indentation de la 1ere ligne d'un paragraphe (autre que 1er)
(define %para-indent% 0pt)

;; indentation des blocs
(define %block-start-indent% 0pt)

;; hyphnation automatique
(define %hyphenation% #t)

;; on supprime toutes les pages de titres autres que celle du livre
(define %generate-set-titlepage% #f)
(define %generate-article-titlepage% #f)
(define %generate-reference-titlepage% #f)
(define %generate-partintro-on-titlepage% #f)

;; authoriser les table de matire pour les Part
(define %generate-part-titlepage% #t)
(define %generate-part-toc% #t)
(define %generate-part-toc-on-titlepage% #t)

;; est-ce que les objets sont flottants ?
(define formal-object-float #t)

;; justification par dfaut : justifi
(define %default-quadding%   'justify)

;; Hauteur de la marge du haut
;;(define %top-margin%  9pi)


<!-- on dfinit notre variable logtrend qui met le copyright en italique -->
(define ($logtrend$)
        ( make sequence font-posture: 'italic (literal " LogTrend http://www.logtrend.org")))

<!-- On dfinit le logo que l'on va inclure sur chaque page -->
(define ($logo$)
         (make external-graphic
		 			scale: 0.65 
	                entity-system-id: "eye.eps"))

<!-- On dfinit le logo pour les pages de dbut de chapitre -->
(define ($logo2$)
         (make external-graphic
		 			scale: 0.65
	                entity-system-id: "logo_logtrend.eps"))


<!-- on redfinit le pied de page gauche pour mettre le copyright -->
(define (page-inner-footer gi)
( make sequence (make rule 
     	 length: 9cm
		 display-alignment: 'start
		line-thickness: 1pt 
		keep-with-previous?: #f)
		(empty-sosofo) ($logtrend$)))

<!-- on redfinit le pied de page gauche des 1eres pages pour mettre le copyright -->
(define (first-page-inner-footer gi)
( make sequence (make rule 
     	 length: 9cm
		 display-alignment: 'start
		line-thickness: 1pt 
		keep-with-previous?: #f)
		(empty-sosofo) ($logtrend$)))

<!-- Logo logtrend en haut  gauche sauf pour les 1eres pages-->
(define (page-inner-header gi)
($logo$))

<!-- pour les 1eres pages, logo  droite avec un trait dessous -->
(define (first-page-outer-header gi)
	($logo2$))
<!--(make sequence
	($logo2$)
	(make rule
		line-thickness: 1pt
        length: 9cm
        display-alignment: 'end)
		(empty-sosofo))) -->


(define (page-center-header gi)
  (let* ((daddy (ancestor "part" (current-node)))
	 (title (if (node-list-empty? daddy)
		    (empty-sosofo)
		    (select-elements (children daddy) 
				     (normalize "title"))))) 
    
    (cond
     ((equal? (normalize gi) (normalize "dedication")) (empty-sosofo))
     ((equal? (normalize gi) (normalize "lot")) (empty-sosofo))
     ((equal? (normalize gi) (normalize "part")) (empty-sosofo))
     ((equal? (normalize gi) (normalize "toc")) (empty-sosofo))
     (else 		 
      (make sequence
;;	font-weight: 'bold
	font-size: (* 1.4 (inherited-font-size))
	(with-mode hf-mode 
	  (process-node-list title))
	(make rule
	  line-thickness: 0pt
	  keep-with-previous?: #f
	  length: 0cm
	  display-alignment: 'end))))))


<!-- en haut  droite pour les pages normales, on met le titre du chapitre + ligne -->
(define (page-outer-header gi)
	 (cond
		((equal? (normalize gi) (normalize "dedication")) (empty-sosofo))
		((equal? (normalize gi) (normalize "lot")) (empty-sosofo))
		((equal? (normalize gi) (normalize "part")) (empty-sosofo))
		((equal? (normalize gi) (normalize "toc")) (empty-sosofo))
		(else 		 
			(make sequence
			  ($title-header-footer$)
			      (make rule
		          line-thickness: 1pt
				  keep-with-previous?: #f
     	 		  length: 9cm
		 		  display-alignment: 'end
)))))

<!-- en bas  droite on met n page + ligne -->
(define (page-outer-footer gi)
  (make sequence
  	(make rule
	    line-thickness: 1pt
     	 length: 9cm
		 display-alignment: 'start
        keep-with-previous?: #f)
  ($page-number-header-footer$)))

											
<!-- idem pour les premires pages -->
(define (first-page-outer-footer gi)
  (cond
    ((equal? (normalize gi) (normalize "dedication")) (empty-sosofo))
	((equal? (normalize gi) (normalize "part")) (empty-sosofo))
	(else 
		(make sequence
			(make rule
     	 		length: 9cm
		 		display-alignment: 'start
				line-thickness: 1pt)
	    	($page-number-header-footer$)))))


<!-- numros romains dbut livre, arabe ensuite -->
<!-- bug de jadetex : ne marche pas en ps -->
(define ($page-number-format$ #!optional (gi (gi)))
  (cond
     ((equal? (normalize gi) (normalize "toc")) "i")
	 ((equal? (normalize gi) (normalize "lot")) "i")
	 ((equal? (normalize gi) (normalize "preface")) "i")
	 (else "1")))


<!-- on ne recommence pas la numrotation  chaque chapitre -->
(define %page-number-restart% #f)

]]>

<!-- ................................................................... -->
<!-- Fin de la partie concernant seulement le postscript ............... -->
<!-- ................................................................... -->



<!-- ................................................................... -->
<!-- Paramtres concernant tous les types de backend  .................. -->
<!-- ................................................................... -->

;; en franais c'est bien
(define %default-language% "fr")

;; numrotation automatique des sections
(define %section-autolabel% #t)

;; les listes de variables n'apparaissent pas comme des tables
(define %may-format-variablelist-as-table% #f)
      
;; ce que l'on met au dbut de chaque liste de listing
(define %indent-programlisting-lines% "    ")
 
;; ce que l'on met au dbut de chaque liste de screen capture
(define %indent-screen-lines% "    ")


<!-- ................................................................... -->
<!-- Fin de paramtres concernant tous les types de backend  ........... -->
<!-- ................................................................... -->

</style-specification-body>
</style-specification>

<!-- on indique que pour tout ce qui n'est pas dfini ici, on se base sur la feuille de style docbook dfinie plus haut -->

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>
