#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Link.pm,v 1.4 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Link  isa Zone
##  Description  : class for tests
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Link.pm,v $
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.2  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.5  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.4  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.3  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.2  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.1  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#

package LogTrend::Visu::Web::Zone::Link;

use strict;

use LogTrend::Common::Duration;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Link object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$valueref);

   $list = $rootnode->getElementsByTagName("ScreenId");
   $node = $list->item(0) || die("Link: No \"ScreenId\" tag.");
   $valueref = $node->getFirstChild() || die("Link: No \"ScreenId\" tag.");
   $self->{SCREENID} = AccentsXML2Text( $valueref->getNodeValue() );

   return $self;
}

##******************************************************************************
## Method propagateInfos  public >Zone
##  Description  : propagates some informations to containned objects
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf,
##                 the screens' xml-id hashtable
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvas,$screenXmlId,$colSize) = @_;
   $self->SUPER::propagateInfos($canvas,$screenXmlId,$colSize);

   if( !defined( $screenXmlId->{ $self->{SCREENID} } ) )
   {
      die( "No such screen '$self->{SCREENID}'" );
   }

   $self->{SCREENPATH} = $screenXmlId->{ $self->{SCREENID} };

}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   $response->contentType("text/html");
   if( $self->{TITLE} ne " " )
   {
      $response->print("      <A HREF=\"../$self->{SCREENPATH}/\">$self->{TITLE}</A>\n");
   }
   else
   {
      $response->print("      &nbsp;\n");
   }
   return $response;
}

##******************************************************************************
1;
