#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Discs.pm,v 1.4 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Discs  isa Zone
##  Description  : class for printing messages
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Discs.pm,v $
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.2  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.10  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.9  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.8  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.7  2001/07/20 13:21:15  slhullier
#
#bytes->kbytes
#
#Revision 1.6  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.5  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.4  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#
#Revision 1.3  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.2  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.1  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#

package LogTrend::Visu::Web::Zone::Discs;

use strict;

use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Discs object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$attributes,$attrnode);

   ##===========================================================================
   ## Thresholds tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Thresholds");
   $node = $list->item(0);
   $self->{WARNING}  = 80;
   $self->{CRITICAL} = 95;
   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Thresholds\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      {  $self->{WARNING} = $attrnode->getValue(); }
      # default = 0

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      {  $self->{CRITICAL} = $attrnode->getValue(); }
   }

   ##===========================================================================
   ## Colors3 tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Colors3");
   $node = $list->item(0);
   $self->      {OKCOLOR} = "#00FF00";
   $self-> {WARNINGCOLOR} = "#FFFF00";
   $self->{CRITICALCOLOR} = "#FF0000";

   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Colors3\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Ok");
      if( defined( $attrnode ) )
      { $self->{OKCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      { $self->{WARNINGCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      { $self->{CRITICALCOLOR} = TextToRGB( $attrnode->getValue() ); }

   }

   return $self;
}

##******************************************************************************
## Method propagateInfos  public >Zone
##  Description  : propagates some informations to containned objects
##                 In the 'Discs' case : determins the devices
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf,
##                 the screens' xml-id hashtable
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvas,$screenXmlId,$colSize) = @_;
   $self->SUPER::propagateInfos($canvas,$screenXmlId,$colSize);

   ##===========================================================================
   ## Determins the devices
   ##===========================================================================
   my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();
   my $expression = $self->{EXPRESSIONS}->[0];

   my @devices = ();
   my $varName = $dataBase->GetListOfDataNameOnAgent( $expression->source(),
                                                      $expression->agent() );
   if( $varName ne "0" )
   {
      foreach my $vn (@$varName)
      {
         if( $vn =~ /^free_space_on_(.*)/ )
         {
            unshift @devices, $1;
         }
      }
   }
   @devices = sort(@devices);
   $self->{DEVICES} = \@devices;

}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();

   my $expression = $self->{EXPRESSIONS}->[0];

   $response->contentType("text/html");
   $response->print("      $self->{TITLE}<BR>\n") if( $self->{TITLE} ne " " );

   if( @{$self->{DEVICES}} == 0 )
   {
      $response->print("      No data" );
      return $response;
   }

   ##===========================================================================
   $response->print("      <TABLE BORDER=\"0\" CELLPADDING=\"2\" CELLSPACING=\"0\">\n");
   $response->print("      <TR>\n");
   $response->print("         <TD>Partition</TD>\n");
   $response->print("         <TD>&nbsp;</TD>\n");
   $response->print("         <TD COLSPAN=\"2\">Percent capacity</TD>\n");
   $response->print("         <TD>&nbsp;</TD>\n");
   $response->print("         <TD ALIGN=\"right\">Free</TD>\n");
   $response->print("      </TR>\n");

   ##===========================================================================
   ## For each device
   ##===========================================================================
   DEV: foreach my $dev (@{$self->{DEVICES}})
   {
      ##========================================================================
      $response->print("      <TR>\n");
      $response->print("         <TD>$dev</TD>\n");
      $response->print("         <TD>&nbsp;</TD>\n");

      ##========================================================================
      my $r = $dataBase->GetData( $expression->source(), $expression->agent(),
                                          "used_space_on_$dev" );
      if( $r eq "0" )
      {
         $response->print("         <TD COLSPAN=\"4\">No data</TD>\n");
         $response->print("      </TR>\n");
         next DEV;
      }
      ##------------------------------------------------------------------------

      my $used = int( $r->[0] + 0.5 );
      my $imsize = $used;
      $imsize = 1  if($imsize<=0);

      ##------------------------------------------------------------------------
      $response->print("         <TD ALIGN=\"right\">$used\%</TD>\n");

      my $color = "#FFFFFF";
      if(    $used >= $self->{CRITICAL} ) { $color = $self->{CRITICALCOLOR}; }
      elsif( $used >= $self->{WARNING}  ) { $color = $self->{WARNINGCOLOR}; }
      else                                { $color = $self->{OKCOLOR}; }

      $response->print("         <TD WIDTH=\"110\">\n");
      $response->print("            <TABLE BORDER=\"0\" WIDTH=\"$imsize\" CELLPADDING=\"0\" CELLSPACING=\"0\"><TR>\n");
      $response->print("               <TD BGCOLOR=\"$color\"><FONT SIZE=\"-2\">&nbsp;</FONT></TD>\n");
      $response->print("            </TR></TABLE>\n");
      $response->print("         </TD>\n");

      $response->print("         <TD>&nbsp;</TD>\n");

      ##========================================================================
      $r = $dataBase->GetData( $expression->source(), $expression->agent(),
                                          "free_space_on_$dev" );
      if( $r eq "0" )
      {
         $response->print("         <TD>No data</TD>\n");
         $response->print("      </TR>\n");
         next DEV;
      }

      ##------------------------------------------------------------------------
      my $free = $r->[0];
      my $freeUnit;
      if( $free >= 1024*1024*1024 )
      {
         $free = $free/(1024*1024*1024);
         $freeUnit = "Tb";
      }
      elsif( $free >= 1024*1024 )
      {
         $free = $free/(1024*1024);
         $freeUnit = "Gb";
      }
      elsif( $free >= 1024 )
      {
         $free = $free/(1024);
         $freeUnit = "Mb";
      }
      else
      {
         $freeUnit = "Kb";
      }
      $free = (int($free*100))/100;
      $free = sprintf "%1.2f", $free;

      $response->print("         <TD ALIGN=\"right\">$free</TD>\n");
      $response->print("         <TD>$freeUnit</TD>\n");


      $response->print("      </TR>\n");
   }


   $response->print("      </TABLE>\n");
   return $response;
}

##******************************************************************************
1;
