#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Alarms.pm,v 1.9 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Alarms  isa Zone
##  Description  : class for printing messages
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##                 Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: Alarms.pm,v $
#Revision 1.9  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.8  2001/11/19 08:23:18  lsimonneau
#Minor bugfixes.
#
#Revision 1.7  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.6  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.5  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.4  2001/11/07 17:57:51  lsimonneau
#Major bugfixes : Javascript work on netscape 4.7x and ie.
#
#Revision 1.3  2001/11/05 14:05:47  lsimonneau
#Major bugfixes.
#
#Revision 1.2  2001/10/24 15:15:11  lsimonneau
#Rewrite alarms acquittement.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.9  2001/10/11 11:31:45  lsimonneau
#Add alarm acquittement.
#
#Revision 1.8  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.7  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.6  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.5  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.4  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.3  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#
#Revision 1.2  2001/06/20 14:22:10  slhullier
#*** empty log message ***
#
#Revision 1.1  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#

package LogTrend::Visu::Web::Zone::Alarms;

use strict;

use POSIX qw(strftime);
use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Alarms object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$attributes,$attrnode);

   ##===========================================================================
   ## Colors3 tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Colors3");
   $node = $list->item(0);
   $self->      {OKCOLOR} = "#005000";
   $self-> {WARNINGCOLOR} = "#FFFF50";
   $self->{CRITICALCOLOR} = "#FF7070";

   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Colors3\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Ok");
      if( defined( $attrnode ) )
      { $self->{OKCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      { $self->{WARNINGCOLOR} = TextToRGB( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      { $self->{CRITICALCOLOR} = TextToRGB( $attrnode->getValue() ); }

   }

   return $self;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();

   ##===========================================================================
   ## In normal-screen request
   ##===========================================================================
   if( ! $request->firstNodeExists() )
   {
       $response->contentType("text/html");
       $response->print( "<script language=\"JavaScript\" > \n".
                         "<!-- \n".
                         " function alarm_display(url){ \n".
                         " window.open(url, \"Alarms\", \"toolbar=no,location=yes,status=no,scrollbars=no,resizable=no,width=600,height=400\");\n".
                         "} \n".
                         "// -->\n".
                         "</script> \n");

       $response->print("      $self->{TITLE}<BR>\n") if( $self->{TITLE} ne " " );

       ##===========================================================================
       ## For each expression
       ##===========================================================================
       my $expressions = $self->{EXPRESSIONS};
       foreach my $expr (@$expressions)
       {
           my $r = $dataBase->GetAlarms($expr->source(), $expr->agent());
           if( $r eq "0" or @$r eq 0 )
           {
               $response->print( "      -- No alarm --\n" );
           }
           else
           {
               $response->print( "      <TABLE BORDER=\"0\" CELLPADDING=\"2\" CELLSPACING=\"0\">\n" );
               foreach my $data (@$r)
               {
                   my $color = $self->{SYSTEMSDECLARATION}->getColor('BackGround');

                   if(    $$data[0] == 1 ) { $color = $self->      {OKCOLOR}; }
                   elsif( $$data[0] == 2 ) { $color = $self-> {WARNINGCOLOR}; }
                   elsif( $$data[0] == 3 ) { $color = $self->{CRITICALCOLOR}; }
                   $response->print( "      <TR>\n");
                   $response->print( "         <TD COLSPAN=\"5\"></TD>\n");
                   $response->print( "      </TR>\n");
                   $response->print( "      <TR>\n");
                   $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
                   $response->print( "         <TD BGCOLOR=\"$color\" ALIGN=\"right\">".
                                     "<FONT SIZE=\"-1\">".
                                     strftime('%c', localtime($$data[2])).
                                     "</FONT></TD>\n");
                   $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
                   $response->print( "         <TD BGCOLOR=\"$color\">");

                   my $dataname = $$data[1];
                   $dataname =~ s/\s/_/g;
                   $dataname =~ s/([^a-zA-Z0-9])/"%".sprintf("%X", ord("$1"))/eg;

                   my $dest_url= $self->ident."/details/?".
                                 "source=".$expr->source."&".
                                 "agent=".$expr->agent."&".
                                 "name=$dataname";


                     $response->print( "             <A HREF=\"javascript:alarm_display(\'$dest_url\');\">$$data[1]</A>");

                   $response->print( "         </TD>\n" );
                   $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
                   $response->print( "      </TR>\n");
               }
               $response->print( "      </TABLE>\n" );
           }
       }
   }
   else {
       my $node = $request->shiftNodes();

       if($node eq "details") {
           $self->generateDetails($request, $response, $dataBase);
       }
       elsif($node eq "acquit") {
           $self->acquitAlarm($request, $response, $dataBase);
       }
   }

   return $response;
}



##******************************************************************************
## Method generateDetails  private
##  Description  : treat a request for detail on alarms
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub generateDetails {
    my ($self,$request, $response, $dataBase) = @_;

    my $source = $request->param('source');
    my $agent = $request->param('agent');
    my $name = $request->param('name');

    $response->contentType("text/html");
    $response->print( "<CENTER><H2>$self->{TITLE}</H2></CENTER>\n" ) if( $self->{TITLE} ne " " );

    my $r = $dataBase->GetAlarmsInTimeInterval(100000, $source, $agent, 0);

    if($r == 0) {
        $response->print( "<CENTER>-- No alarm --<A HREF=\"\" onclick=\"window.close();\">Close the window</A></CENTER>\n" );
        return $response;
    }

    my @my_alarms;
    $name =~ s/_/ /g;
    foreach my $alarm (@$r) {
        if($alarm->[1] eq $name) {
            push @my_alarms, $alarm;
        }
    }

    if( @my_alarms == 0 )
    {
        $response->print( "<CENTER>-- No alarm --<BR><A HREF=\"\" onclick=\"window.close();\">Close the window</A></CENTER>\n" );
        return $response;
    }

    $response->print( "      <CENTER><TABLE BORDER=\"0\" CELLPADDING=\"2\" CELLSPACING=\"0\">\n" );
    $response->print( "      <TR>\n");
    $response->print( "         <TD COLSPAN=\"5\"></TD>\n");
    $response->print( "      </TR>\n");

    my $color;

    # print not acquitted alarms
    my $i;
    for($i = 0; $i < @my_alarms; $i++) {
        my $alarm=$my_alarms[$i];

        next if defined $alarm->[3];

        $color = "#FFFFFF";

        if(    $alarm->[0] == 1 ) { $color = $self->      {OKCOLOR}; }
        elsif( $alarm->[0] == 2 ) { $color = $self-> {WARNINGCOLOR}; }
        elsif( $alarm->[0] == 3 ) { $color = $self->{CRITICALCOLOR}; }
        $response->print( "      <TR>\n");
        $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
        $response->print( "         <TD BGCOLOR=\"$color\" ALIGN=\"right\">".
                          "<FONT SIZE=\"-1\">".
                          strftime('%c', localtime($alarm->[2])).
                          "</FONT></TD>\n");
        $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
        $response->print( "         <TD BGCOLOR=\"$color\">$alarm->[1]</TD>\n");
        $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>" );
        $response->print( "         <TD BGCOLOR=\"$color\">" );
        $response->print( "            <FORM METHOD=get ACTION=\"../acquit/\">" );
        $response->print( "               <INPUT NAME=\"source\" VALUE=\"$source\" TYPE=\"HIDDEN\">" );
        $response->print( "               <INPUT NAME=\"agent\" VALUE=\"$agent\" TYPE=\"HIDDEN\">" );
        $response->print( "               <INPUT NAME=\"name\" VALUE=\"$name\" TYPE=\"HIDDEN\">" );
        $response->print( "               <INPUT NAME=\"level\" VALUE=\"$alarm->[0]\" TYPE=\"HIDDEN\">" );
        $response->print( "               <INPUT NAME=\"acquit\" VALUE=\"Acquit this alarm\" TYPE=SUBMIT>" );
        $response->print( "            </FORM></TD>\n" );
        $response->print( "      </TR>\n");
    }

    # No more alarms
    if($i==0) {
        $response->print("<CENTER>No more alarm.<BR><A HREF=\"\" onclick=\"window.close();\">Close the window</A></CENTER>");

        return $response;
    }

    # print acquitted alarms
    $response->print( "      </TABLE></CENTER><BR><BR>\n" );
    $response->print( "<CENTER><H3>Previous '$name' Alarms</H3></CENTER>\n" );

    if($i == @my_alarms) {
        $response->print( "<CENTER>-- none --</CENTER>\n");
    }
    else {
        $response->print( "      <CENTER><TABLE BORDER=\"0\" CELLPADDING=\"2\" CELLSPACING=\"0\">\n" );
        $response->print( "      <TR>\n");
        $response->print( "         <TH COLSPAN=\"1\"/>");
        $response->print( "         <TH COLSPAN=\"1\">Release Date</TH>\n");
        $response->print( "         <TH COLSPAN=\"1\"/>");
        $response->print( "         <TH COLSPAN=\"1\">Acquittal Date</TH>\n");
        $response->print( "         <TH COLSPAN=\"1\"/>");
        $response->print( "      </TR>\n");

        for(; $i < @my_alarms; $i++) {
            my $alarm=$my_alarms[$i];

            $color = "#FFFFFF";
            if(    $alarm->[0] == 1 ) { $color = $self->      {OKCOLOR}; }
            elsif( $alarm->[0] == 2 ) { $color = $self-> {WARNINGCOLOR}; }
            elsif( $alarm->[0] == 3 ) { $color = $self->{CRITICALCOLOR}; }

            $response->print( "      <TR>\n");
            $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
            $response->print( "         <TD BGCOLOR=\"$color\" ALIGN=\"right\">".
                              "<FONT SIZE=\"-1\">".
                              strftime('%c', localtime($alarm->[2])).
                              "</FONT></TD>\n");
            $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
            $response->print( "         <TD BGCOLOR=\"$color\" ALIGN=\"right\">".
                              "<FONT SIZE=\"-1\">".
                              strftime('%c', localtime($alarm->[3])).
                              "</FONT></TD>\n");
            $response->print( "         <TD BGCOLOR=\"$color\">&nbsp;</TD>\n" );
            $response->print( "      </TR>\n");
        }
        $response->print( "      </TABLE></CENTER>\n" );
    }

    $response->print("<BR><BR><CENTER><A HREF=\"\" onclick=\"window.close();\">Close the window</A></CENTER>");

    return $response;
}


##******************************************************************************
## Method acquitAlarm  private
##  Description  : treat a request for acquit alarms
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub acquitAlarm {
    my ($self,$request, $response, $dataBase) = @_;

    my $source = $request->param('source');
    my $agent = $request->param('agent');
    my $name = $request->param('name');
    my $level = $request->param('level');

    if(! $dataBase->AcquitAlarm($source, $agent, $name, $level)) {
        $response->contentType("text/html");
          $response->print( "<B>Error</B><BR> Can't acquit this alarm" );
          return;
    }

    $response->contentType("text/html");

    my $url = "../details/?source=$source&agent=$agent";
    $name =~  s/([^a-zA-Z0-9])/"%".sprintf("%X", ord("$1"))/eg;
    $url .= "&name=$name";

    $response->print("<meta http-equiv=\"refresh\" content=\"1;URL=$url\">");
    $response->print("<CENTER>Alarm Acquitted<BR><A HREF=\"$url\">Return to alarm details page</A></CENTER>");
}

##******************************************************************************
1;
