#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/VisuClass.pm,v 1.6 2001/11/14 15:59:45 slhullier Exp $
##******************************************************************************
## Class VisuClass isa LogTrend::Visu::VisuClass
##  Description  : correspond to Class XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: VisuClass.pm,v $
#Revision 1.6  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.5  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.4  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.3  2001/10/25 14:55:23  slhullier
#Class Web attribute
#
#Revision 1.2  2001/10/24 12:00:39  slhullier
#First version for report-generation
#
#Revision 1.1  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#

package LogTrend::Visu::Web::VisuClass;

use strict;
use XML::DOM;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Constants;
use LogTrend::Visu::VisuClass;
use LogTrend::Visu::Web::Screen;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::VisuClass");

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node
##******************************************************************************
sub new
{
   my ($classname,$rnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub getNameFromXML
{
   my ($self,$rnode) = @_;

   my $attributes = $rnode->getAttributes();
   my $attrnode = $attributes->getNamedItem("Web");

   if( defined( $attrnode ) )
   { return $attrnode->getValue(); }

   return undef;
}

##******************************************************************************
sub newScreen
{
   my ($self,$kid,$systemsDeclaration,$screen_nbr) = @_;
   return new LogTrend::Visu::Web::Screen( $kid, $systemsDeclaration, $screen_nbr );
}

##******************************************************************************
## Method treat  public
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $screen = $request->firstNode();

   ##===========================================================================
   ## Existing screen
   ##===========================================================================
   if( defined( $self->{SCREEN}->{$screen} ) )
   {
      $request->shiftNodes();
      return $self->{SCREEN}->{$screen}->treat( $request );
   }

   ##===========================================================================
   ## Not existing screen
   ##===========================================================================
   my $response = new LogTrend::Visu::Response();
   $response->contentType("text/html");
   $response->print( "<B>Error</B><BR>No such screen $screen" );
   return $response;

}

##******************************************************************************
1;
