#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Screen.pm,v 1.6 2001/12/27 17:10:25 slhullier Exp $
##******************************************************************************
## Class Screen isa LogTrend::Visu::Screen
##  Description  : correspond to the Zone XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Screen.pm,v $
#Revision 1.6  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#
#Revision 1.5  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.4  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.3  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.2  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.1  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#

package LogTrend::Visu::Web::Screen;

use strict;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Screen;
use LogTrend::Visu::Zone;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Screen");

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node, the screen number
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration,$screen_nbr) = @_;
   my ($outputType) = ($classname =~ /.*::([^:]*)::[^:]*/);
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration,$screen_nbr,$outputType);
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method treat  public >LogTrend::Visu::Screen
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $zone = $self->{ZONE};
   my $response = new LogTrend::Visu::Response();

   ##===========================================================================
   ## Request with zone (certainly for an image)
   ##===========================================================================
   if( $request->firstNodeExists() )
   {
      my $zoneNode = $request->firstNode();

      ##------------------------------------------------------------------------
      ## Existing zone
      ##------------------------------------------------------------------------
      if( defined( $zone->{$zoneNode} ) )
      {
         $request->shiftNodes();
         return $zone->{$zoneNode}->treat( $request );
      }

      ##------------------------------------------------------------------------
      ## Not existing zone
      ##------------------------------------------------------------------------

      $response->contentType("text/html");
      $response->print( "<B>Error</B><BR>No such zone $zoneNode" );
      return $response;

   }

   ##===========================================================================
   ## Request without zone (for a normal screen view)
   ##===========================================================================
   $response->contentType("text/html");
   $response->print( "<HTML>\n" );
   $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                             " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                             " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                            " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );

   $response->print( "<CENTER>\n" );
   $response->print( "   <B><FONT SIZE=\"+1\">$self->{SYSTEMLEAFNAME}</FONT></B><BR>\n" );
   if( $self->{SYSTEMLEAFDESC} ne "" )
   {
      $response->print( "   --- $self->{SYSTEMLEAFDESC} ---<BR>\n" );
   }
   $response->print( "   <B>$self->{NAME}</B><BR>\n" );
   $response->print( "</CENTER><BR>\n" );
   $response->print( "<TABLE BORDER=\"0\" CELLPADDING=\"3\" CELLSPACING=\"1\">\n" );
   my $positions = $self->{POSITIONS};
   my $positions_x_max = $self->{POSITIONS_X_MAX};
   my $positions_y_max = $self->{POSITIONS_Y_MAX};
   my %done = ();

   ##---------------------------------------------------------------------------
   ## For each position
   ##---------------------------------------------------------------------------
   for( my $y=0; $y<=$positions_y_max; $y++ )
   {
      next if( !defined( $positions->{"0,$y"} ) );

      $response->print( "<TR>\n" );
      for( my $x=0; $x<=$positions_x_max; $x++ )
      {
         if( $positions->{"$x,$y"} eq ".." )
         {
            $response->print( "   <TD WIDTH=\"".$self->{COLSIZE}."\"" );
            $response->print( " BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\">&nbsp;</TD>\n" );
         }
         else
         {
            my $zoneIdent = $positions->{"$x,$y"};

            if( !defined( $done{$zoneIdent} ) )
            {
               $done{$zoneIdent} = 1;
               my $zoneRef = $zone->{$zoneIdent};
               $response->print( "   <TD" );
               $response->print( " BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('CellGround')."\"" );
               $response->print( " WIDTH=\"".$self->{COLSIZE}*$zoneRef->width()."\"" );
               $response->print( " COLSPAN=\"".$zoneRef->width()."\"" );
               $response->print( " ROWSPAN=\"".$zoneRef->height()."\"" );
               $response->print( " ALIGN=\"center\"" );
               $response->print( " VALIGN=\"top\">\n" );

               my $zoneResponse = $zoneRef->treat( $request );
               if( $zoneResponse->contentType() eq "text/html" )
               {
                  my $c = $zoneResponse->getContent();
                  $response->print( $c );
               }
               else
               {
                  $response->print( "Error:<BR>\n" );
                  $response->print( "contentType = " );
                  $response->print( $zoneResponse->contentType()."<BR>\n" );
               }

               $response->print( "   </TD>\n" );
            }
            else
            {
               # rien
            }
         }
      }
      $response->print( "</TR>\n" );
   }

   $response->print( "</TABLE>\n" );



   $response->print( "<BR>\n" );
   $response->print( LogTrend::Visu::Utils::dateHTMLString() );
   $response->print( "<BR>\n" );
   $response->print( "</BODY>\n" );
   $response->print( "</HTML>\n" );
   return $response;
}

##******************************************************************************
1;
