#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/NetworkNode.pm,v 1.3 2001/11/14 14:01:51 slhullier Exp $
##******************************************************************************
## Class NetworkNode  isa LogTrend::Visu::NetworkNode isa ArchitectureNode
##  Description  : class for network (correspond to Network XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: NetworkNode.pm,v $
#Revision 1.3  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.2  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.1  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#

package LogTrend::Visu::Web::NetworkNode;

use strict;

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Web::SystemLeaf;
use LogTrend::Visu::Web::NetworkNode;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::NetworkNode");

##******************************************************************************
## Constructor  public
##  Parameters   : the root node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub newNetworkNode
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::NetworkNode( $kid, $systemsDeclaration );
}

##******************************************************************************
sub newSystemLeaf
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::SystemLeaf( $kid, $systemsDeclaration );
}

##******************************************************************************
## Method buildTree_header  protected >LogTrend::Visu::NetworkNode
##  Description  : called by buildTree for the header
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub buildTree_header
{
   my ($self) = @_;

   my $result = "<LI>$self->{NAME}\n";
   $result .= "<UL>\n";
   if( $self->{DESCRIPTION} ne "" )
   {
      $result .= "<LH>\n";
      $result .= "$self->{DESCRIPTION}\n";
      $result .= "</LH>\n";
   }

   return $result;
}

##******************************************************************************
## Method buildTree_footer  protected
##  Description  : called by buildTree for the footer
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub buildTree_footer
{
   my ($self) = @_;
   return "</UL><BR>\n";
}

##******************************************************************************
## Method treat  public >ArchitectureNode
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $architectureNode = $self->{ARCHITECTURENODE};
   my $response = new LogTrend::Visu::Response();
   my $node;

   ##===========================================================================
   ## Request with nodes
   ##===========================================================================
   if( $request->firstNodeExists() )
   {
      $node = $request->firstNode();

      ##------------------------------------------------------------------------
      ## Existing node
      ##------------------------------------------------------------------------
      if( defined( $architectureNode->{$node} ) )
      {
         $request->shiftNodes();
         return $architectureNode->{$node}->treat( $request );
      }

      ##------------------------------------------------------------------------
      ## Not existing node : perhaps it was identified by it's name ?
      ##------------------------------------------------------------------------
      foreach my $node_ident (keys %$architectureNode)
      {
          if($architectureNode->{$node_ident}->getName eq $node)
          {
              $request->shiftNodes;
              return $architectureNode->{$node_ident}->treat( $request );
          }
      }


      ##------------------------------------------------------------------------
      ## Not existing node
      ##------------------------------------------------------------------------

      $response->contentType("text/html");
      $response->print( "<B>Error</B><BR>No such node $node" );
      return $response;

   }

   ##===========================================================================
   ## Request without node
   ##===========================================================================
   $response->contentType("text/html");
   $response->print( "<B>Error</B><BR>You are in a NetworkNode" );

   return $response;
}

##******************************************************************************
1;
