#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/MessageNode.pm,v 1.1 2001/11/26 15:52:31 slhullier Exp $
##******************************************************************************
## Class MessageNode  isa ArchitectureNode
##  Description  : class for a web message
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: MessageNode.pm,v $
#Revision 1.1  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#

package LogTrend::Visu::Web::MessageNode;

use strict;

use LogTrend::Visu::ArchitectureNode;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::ArchitectureNode");

##******************************************************************************
## Constructor  public
##  Parameters   : its name, its message, the systemsdeclaration
##******************************************************************************
sub new
{
   my ($classname,$name,$message,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new();

   $self->{NAME}               = $name;
   $self->{MESSAGE}            = $message;
   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;

   bless($self, $classname);
   return $self;

}

##******************************************************************************
## Method buildTree  public >ArchitectureNode
##  Description  : put this object in an HTML tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self,$dir) = @_;

   my $here;
   if( $dir ne "" ) { $here = $dir."/".$self->ident(); }
   else             { $here = $self->ident(); }

   my $result = "<LI><A HREF=\"".$here."/s000/\" TARGET=\"right\">$self->{NAME}</A>";
   $result .= "\n";

   return $result;
}

##******************************************************************************
## Method treat  public >LogTrend::Visu::SystemLeaf >ArchitectureNode
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();
   $response->contentType("text/html");
   $response->print( "<HTML>\n" );
   $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                             " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                             " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                            " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
   $response->print( "<B><BR><BR><BR><CENTER>$self->{MESSAGE}</CENTER></B>\n" );
   $response->print( "</BODY></HTML>\n" );
   return $response;
}

##******************************************************************************
1;
