#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/SystemsDeclaration.pm,v 1.43 2001/12/05 16:32:36 slhullier Exp $
##******************************************************************************
## Class SystemsDeclaration
##  Description  : correspond to the root of the XML file
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemsDeclaration.pm,v $
#Revision 1.43  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.42  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#
#Revision 1.41  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.40  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.39  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.38  2001/11/15 14:42:55  slhullier
#DataBaseManager adding
#
#Revision 1.37  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.36  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.35  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.34  2001/11/14 13:14:13  slhullier
#*** empty log message ***
#
#Revision 1.33  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.32  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.31  2001/10/29 14:06:02  slhullier
#Stable but non-realy working report via the web
#
#Revision 1.30  2001/10/25 14:25:41  slhullier
#First working version for reports
#
#Revision 1.29  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#
#Revision 1.28  2001/10/15 07:54:43  slhullier
#In english
#
#Revision 1.27  2001/10/05 11:11:09  slhullier
#Some french texts to english
#
#Revision 1.26  2001/09/27 16:06:40  slhullier
#Configuration by XML file works.
#
#Revision 1.25  2001/09/19 09:55:38  slhullier
#*** empty log message ***
#
#Revision 1.24  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.23  2001/09/07 13:22:17  lsimonneau
#Add support of URL like http://myserver.com/LogTrendVisu/MyClientName/TheNetwork/
#
#Revision 1.22  2001/08/24 09:05:31  slhullier
#
#DOM trees destruction
#
#Revision 1.21  2001/08/21 08:45:07  slhullier
#
#Colors personnalisable + dial mis en place
#
#Revision 1.20  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.19  2001/08/10 14:47:29  slhullier
#
#Begining of URL XML-encoding ; stable but not finished
#
#Revision 1.18  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.17  2001/07/24 14:38:41  slhullier
#
#Scripting for Visu
#
#Revision 1.16  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.15  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.14  2001/06/26 16:50:54  slhullier
#
#Led sans image, message plus beaux ...
#
#Revision 1.13  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.12  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.11  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.10  2001/06/20 14:22:10  slhullier
#*** empty log message ***
#
#Revision 1.9  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.8  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.7  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::SystemsDeclaration;

use strict;
use XML::DOM;
use LogTrend::Visu::DataBaseManager;
use LogTrend::Visu::Entity;
use LogTrend::Visu::NetworkNode;
use LogTrend::Visu::SystemLeaf;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the user, the root-node, optional VisuClass/start/stop values
##******************************************************************************
sub new
{
   my ($classname,$user,$visuClass,$start,$stop) = @_;
   my $self = {};
   bless($self, $classname);

   $self->{USER} = $user;
   $self->{VISUCLASS} = $visuClass;
   $self->{START} = $start;
   $self->{STOP} = $stop;
   $self->{DATABASE} = undef;
   $self->{XMLDIRECTORY} = "$CstUsersPath/$user";

   ##===========================================================================
   my $file = $self->getXMLDirectory()."/network.xml";

   my $Utils_CurrentFile_Sav = $Utils_CurrentFile;
   $Utils_CurrentFile = "$file";
   my $parser = new XML::DOM::Parser() || die($!);
   open( FILE, "$file" ) || die("$file: $!");
   close(FILE);
   my $doc = $parser->parsefile( $file ) || die("$file: $!");

   my $rootlist = $doc->getElementsByTagName("SystemsDeclaration") ||
                                         die("No \"SystemsDeclaration\" tag.");
   my $rootnode = $rootlist->item(0) || die("No \"SystemsDeclaration\" tag.");
   ##===========================================================================

   my @contact = ();
   my %entity = ();
   my %architectureNode = ();
   $self->{ENTITY}           = \%entity;

   foreach my $att ( 'BackGround', 'CellGround', 'Text', 'Links', 'VisitedLinks' )
   {
      $self->{"COLOR_$att"} = $CstHTMLColors{$att};
   }

   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Name" )
      {
         $self->{NAME} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() );
      }
      elsif( $nodeName eq "DataBaseFile" )
      {
         $self->dataBase( $kid->getFirstChild()->getNodeValue() );
      }
      elsif( $nodeName eq "Reference" )
      {
         $self->{REFERENCE} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() );
      }
      elsif( $nodeName eq "Contact" )
      {
         my %c = ();
         my $attributes = $kid->getAttributes();
         my $attrnode;

         $attrnode = $attributes->getNamedItem("Firstname");
         if( defined( $attrnode ) )
         { $c{FIRSTNAME} = AccentsXML2Text( $attrnode->getValue() ); }
         else
         { $c{FIRSTNAME} = ""; }

         $attrnode = $attributes->getNamedItem("Surname");
         if( defined( $attrnode ) )
         { $c{SURNAME} = AccentsXML2Text( $attrnode->getValue() ); }
         else
         { $c{SURNAME} = ""; }

         $attrnode = $attributes->getNamedItem("Email");
         if( defined( $attrnode ) ) { $c{EMAIL} = AccentsXML2Text( $attrnode->getValue() ); }
         else                       { $c{EMAIL} = ""; }

         push @contact, \%c;

      }
      elsif( $nodeName eq "Colors" )
      {
         $self->Colors( $kid );
      }
      elsif( $nodeName eq "Entity" )
      {
         my $e = new LogTrend::Visu::Entity( $kid );
         $entity{$e->number()} = $e;
      }
      elsif( $nodeName eq "Network" )
      {
         my $n = $self->newNetworkNode( $kid, $self );
         if( defined($n) ) # some systems are not wanted for reports or web
         {
            $architectureNode{$n->ident()} = $n;
         }
      }
      elsif( $nodeName eq "System" )
      {
         my $s = $self->newSystemLeaf( $kid, $self );
         if( defined($s) ) # some systems are not wanted for reports or web
         {
            $architectureNode{$s->ident()} = $s;
         }
      }
      elsif( $nodeName eq "User" )
      {
         my $u = $self->newUserNode( $kid, $self );
         if( defined($u) ) # some systems are not wanted for reports or web
         {
            $architectureNode{$u->ident()} = $u;
         }
      }

   }

   $self->{CONTACT}          = \@contact;
   $self->{ARCHITECTURENODE} = \%architectureNode;

   ##===========================================================================
   $doc->dispose();
   $doc = $parser = undef;

   $Utils_CurrentFile = $Utils_CurrentFile_Sav;
   ##===========================================================================

   return $self;
}

##******************************************************************************
## Method Colors  protected
##  Description  : reads the colors value
##  Parameters   : the XML Colors tag
##  Return value : none
##******************************************************************************
sub Colors
{
   my ($self,$node) = @_;

   my $attributes = $node->getAttributes() || die("Error in \"Colors\".");
   foreach my $att ( 'BackGround', 'CellGround', 'Text', 'Links', 'VisitedLinks' )
   {
      my $attrnode = $attributes->getNamedItem($att);
      if( defined( $attrnode ) )
      {
         $self->{"COLOR_$att"} = TextToRGB( AccentsXML2Text( $attrnode->getValue() ) );
      }
   }
}

##******************************************************************************
## Method dataBase  protected
##  Description  : creat the object to connect to the database
##  Parameters   : the XML database file name
##  Return value : the database object
##******************************************************************************
sub dataBase
{
   my ($self,$file) = @_;

   $file = $self->getXMLDirectory()."/$file";

   my $parser = new XML::DOM::Parser() || die($!);
   open( FILE, "$file" ) || die("<CODE>$file</CODE>: $!");
   close(FILE);

   my $Utils_CurrentFile_Sav = $Utils_CurrentFile;
   $Utils_CurrentFile = "$file";

   my $doc = $parser->parsefile( $file ) || die($file);

   my $rootlist = $doc->getElementsByTagName("Infos") ||
                                         die("$file: No \"Infos\" tag.");
   my $rootnode = $rootlist->item(0) || die("$file: No \"Infos\" tag.");

   my ($dataBase,$host,$port,$user,$password) = (undef,undef,undef,undef,undef);
   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "DataBase" )
      {
         $self->{BD_DATABASE} = $kid->getFirstChild()->getNodeValue();
      }
      elsif( $nodeName eq "Host" )
      {
         $self->{BD_HOST} = $kid->getFirstChild()->getNodeValue();
      }
      elsif( $nodeName eq "Port" )
      {
         $self->{BD_PORT} = $kid->getFirstChild()->getNodeValue();
      }
      elsif( $nodeName eq "User" )
      {
         $self->{BD_USER} = $kid->getFirstChild()->getNodeValue();
      }
      elsif( $nodeName eq "Password" )
      {
         $self->{BD_PASSWORD} = $kid->getFirstChild()->getNodeValue();
      }
   }

   die("No DataBase tag in database file") if( !defined($self->{BD_DATABASE}) );
   die("No Host tag in database file")     if( !defined($self->{BD_HOST})     );
   die("No Port tag in database file")     if( !defined($self->{BD_PORT})     );
   die("No User tag in database file")     if( !defined($self->{BD_USER})     );
   die("No Password tag in database file") if( !defined($self->{BD_PASSWORD}) );

   $Utils_CurrentFile = $Utils_CurrentFile_Sav;

   $doc->dispose();
   $doc = $parser = undef;
}

##******************************************************************************
## Method getDataBase  public
##******************************************************************************
sub getDataBase
{
   my ($self) = @_;
   return LogTrend::Visu::DataBaseManager->getDatabase( $self->{BD_DATABASE},
             $self->{BD_HOST}, $self->{BD_PORT}, $self->{BD_USER}, $self->{BD_PASSWORD} );
}

##******************************************************************************
## Method getEntity  public
##  Description  : return a reference to an Entity
##  Parameters   : the number of the Entity (XML field Number)
##  Return value : a reference
##******************************************************************************
sub getEntity
{
   my ($self,$number) = @_;

   my $entity = $self->{ENTITY};
   if( !defined( $$entity{$number} ) )
   { die( "No such Entity number '$number'" ); }

   return $$entity{$number};
}

##******************************************************************************
## Method getColor  public
##******************************************************************************
sub getColor
{
   my ($self,$color) = @_;
   return $self->{"COLOR_$color"};
}

##******************************************************************************
## Method getStartStop  public
##******************************************************************************
sub getStartStop
{
   return ($_[0]->{START},$_[0]->{STOP});
}

##******************************************************************************
## Method get<WIDGET>  public
##******************************************************************************
sub getName         { return $_[0]->{NAME};      }
sub getReference    { return $_[0]->{REFERENCE}; }
sub getContacts     { return $_[0]->{CONTACT};   }
sub getVisuClass    { return $_[0]->{VISUCLASS}; }
sub getUser         { return $_[0]->{USER}; }
sub getXMLDirectory { return $_[0]->{XMLDIRECTORY}; }

##******************************************************************************
1;
