#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Screen.pm,v 1.22 2001/11/19 10:56:54 slhullier Exp $
##******************************************************************************
## Class Screen
##  Description  : correspond to the Zone XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Screen.pm,v $
#Revision 1.22  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.21  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.20  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.19  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.18  2001/10/23 12:26:36  lsimonneau
#Change Web::Zone to Zone.
#
#Revision 1.17  2001/10/23 12:01:01  slhullier
#Web/Report
#
#Revision 1.16  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#
#Revision 1.15  2001/08/21 08:45:07  slhullier
#
#Colors personnalisable + dial mis en place
#
#Revision 1.14  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.13  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.12  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.11  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.10  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.9  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.8  2001/06/18 16:12:43  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.7  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.6  2001/06/15 07:15:14  slhullier
#
#Essai
#

package LogTrend::Visu::Screen;

use strict;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node, the screen number, the output-type
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration,$screen_nbr,$outputType) = @_;
   my $self = {};
   bless($self, $classname);

   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;

   my %zone = ();
   my $zone_nbr = 0;
   my %positions = ();
   my $positions_y_max = -1;
   my $positions_x_max = -1;

   my $attributes = $rootnode->getAttributes() || die("Error in \"Screen\" tag.");
   my $attrnode = $attributes->getNamedItem("Id") ||
                   die("No 'Id' field in \"Screen\" tag.");
   $self->{SCREEN_XML_ID} = AccentsXML2Text( $attrnode->getValue() );

   $attrnode = $attributes->getNamedItem("ColSize") ||
                die("No 'ColSize' field in \"Screen\" tag.");
   $self->{COLSIZE} = AccentsXML2Text( $attrnode->getValue() );

   ##===========================================================================
   $self->{DESCRIPTION} = "";
   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Name" )
      { $self->{NAME} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Description" )
      { $self->{DESCRIPTION} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      ##------------------------------------------------------------------------
      elsif( $nodeName eq "Zone" )
      {
         my $z = LogTrend::Visu::Zone->newZone( $kid, $systemsDeclaration,
                                                $zone_nbr, $outputType );
         my $ident = $z->ident();
         $zone{$ident} = $z;
         $zone_nbr++;

         for( my $y=$z->y(); $y<$z->y()+$z->height(); $y++ )
         {
            for( my $x=$z->x(); $x<$z->x()+$z->width(); $x++ )
            {
               if( defined( $positions{"$x,$y"} ) )
               {
                  die("Zones overlapping at (x=$x,y=$y) with ".
                      $zone{$positions{"$x,$y"}}->whoAmI()." and ".
                      $z->whoAmI()."<BR>");
               }
               $positions{"$x,$y"} = $ident;
               $positions_x_max = $x if( $x > $positions_x_max );
            }
            $positions_y_max = $y if( $y > $positions_y_max );
         }
      }
      ##------------------------------------------------------------------------
   }

   die("No Name in Screen XML tag") if( !defined($self->{NAME}) );

   ##===========================================================================
   ## Delete equal lines
   ##===========================================================================
   for( my $y=0; $y<=$positions_y_max; $y++ )
   {
      for( my $x=0; $x<=$positions_x_max; $x++ )
      {
         if( !defined( $positions{"$x,$y"} ) )
         { $positions{"$x,$y"} = ".."; }
      }
   }

   Y: for( my $y=0; $y<$positions_y_max; $y++ )
   {
      for( my $x=0; $x<=$positions_x_max; $x++ )
      {
         if( $positions{"$x,$y"} ne $positions{"$x,".($y+1)} )
         { next Y; }
      }
      # y equals y+1 : suppress y
      my %done = ();
      for( my $x=0; $x<=$positions_x_max; $x++ )
      {
         if( ( $positions{"$x,$y"} ne ".." ) &&
             ( !defined($done{$positions{"$x,$y"}}) ) )
         {
            $zone{$positions{"$x,$y"}}->{HEIGHT} --;
            $done{$positions{"$x,$y"}} = 1;
         }
         undef( $positions{"$x,$y"} );
      }
   }

   ##===========================================================================
   $self->{ZONE}  = \%zone;
   $self->{POSITIONS} = \%positions;
   $self->{POSITIONS_X_MAX} = $positions_x_max;
   $self->{POSITIONS_Y_MAX} = $positions_y_max;
   $self->{IDENT} = "s".sprintf("%03d",$screen_nbr);

   return $self;
}

##******************************************************************************
## Method ident  public
##  Description  : return the identificator value
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub ident
{
   my ($self) = @_;
   return $self->{IDENT};
}

##******************************************************************************
## Method screenXmlId  public
##  Description  : return the XML Id value of the Screen
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub screenXmlId
{
   my ($self) = @_;
   return $self->{SCREEN_XML_ID};
}

##******************************************************************************
## Method propagateInfos  public
##  Description  : propagates some informations to containned objects
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf,
##                 the SystemLeaf's name and description,
##                 the screens' xml-id hashtable
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvas,$systemLeafName,$systemLeafDesc,$screenXmlId) = @_;
   my $zone = $self->{ZONE};
   foreach my $var (keys %$zone)
   {
      $zone->{$var}->propagateInfos( $canvas, $screenXmlId, $self->{COLSIZE} );
   }
   $self->{SYSTEMLEAFNAME} = $systemLeafName;
   $self->{SYSTEMLEAFDESC} = $systemLeafDesc;
}

##******************************************************************************
## Method treat  public
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
}

##******************************************************************************
1;
