#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/VisuClass.pm,v 1.7 2001/11/14 15:59:45 slhullier Exp $
##******************************************************************************
## Class VisuClass isa LogTrend::Visu::VisuClass
##  Description  : correspond to Class XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: VisuClass.pm,v $
#Revision 1.7  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.6  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.5  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.4  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.3  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.2  2001/10/26 07:41:47  slhullier
#Tag Report or tag Web+"_Report" for filename
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::VisuClass;

use strict;
use XML::DOM;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Constants;
use LogTrend::Visu::VisuClass;
use LogTrend::Visu::Report::Screen;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::VisuClass");

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub getNameFromXML
{
   my ($self,$rnode) = @_;

   my $c = $self->{SYSTEMSDECLARATION}->getVisuClass();
   return $c if( defined($c) );

   my $attributes = $rnode->getAttributes();
   my $attrnode = $attributes->getNamedItem("Report");
   return $attrnode->getValue() if( defined( $attrnode ) );

   return undef;
}

##******************************************************************************
sub newScreen
{
   my ($self,$kid,$systemsDeclaration,$screen_nbr) = @_;
   return new LogTrend::Visu::Report::Screen( $kid, $systemsDeclaration, $screen_nbr );
}

##******************************************************************************
## Method buildTree  public
##  Description  : build the report
##  Parameters   : none
##  Return value : docbook string, undef if no screen defined
##******************************************************************************
sub buildTree
{
   my ($self) = @_;
   my $result = "";

   return undef if( !defined( $self->{SCREEN} ) );

   my $screen = $self->{SCREEN};

   foreach my $var (sort keys %$screen)
   {
      $result .= $screen->{$var}->buildTree();
   }

   return $result;
}

##******************************************************************************
1;
