#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/SystemsDeclaration.pm,v 1.12 2002/01/04 16:06:55 slhullier Exp $
##******************************************************************************
## Class SystemsDeclaration isa LogTrend::Visu::SystemsDeclaration
##  Description  : correspond to the root of the XML file
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemsDeclaration.pm,v $
#Revision 1.12  2002/01/04 16:06:55  slhullier
#/etc/init.d/LogTrendVisu report generation bug solved
#
#Revision 1.11  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#
#Revision 1.10  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.9  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.8  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.7  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.6  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.5  2001/11/14 13:14:13  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.3  2001/10/29 14:06:03  slhullier
#Stable but non-realy working report via the web
#
#Revision 1.2  2001/10/25 14:25:41  slhullier
#First working version for reports
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::SystemsDeclaration;

use strict;
use Error qw(:try);
use POSIX qw(strftime);
use XML::DOM;

use LogTrend::Visu::Entity;
use LogTrend::Visu::SystemLeaf;
use LogTrend::Visu::Constants;
use LogTrend::Visu::SystemsDeclaration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Report::NetworkNode;
use LogTrend::DataBaseAccess::PostgreSQLDataBase;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::SystemsDeclaration");

##******************************************************************************
## Constructor  public >LogTrend::Visu::SystemsDeclaration
##  Parameters   : the user, the XML root node, an optional ref on hash-table
##                 with form values
##******************************************************************************
sub new
{
   my ($classname,$user,$param) = @_;

   my $visuClass = undef;
   my $start = undef;
   my $stop = undef;
   if( defined($param) )
   {
      $visuClass = ${$param}{VISUCLASS};
      $start     = ${$param}{START};
      $stop      = ${$param}{STOP};
   }
   my $self;
   $self = $classname->SUPER::new( $user, $visuClass, $start, $stop );
   bless($self, $classname);

   if( defined($param) )
   {
      ##------------------------------------------------------------------------
      ## Already-defined variables
      ##------------------------------------------------------------------------
      $self->{NAME}      = ${$param}{TITLE};
      $self->{REFERENCE} = ${$param}{REFERENCE};
      $self->{CONTACT}   = undef;
      $self->{CONTACT}   = ${$param}{CONTACT};

      ##------------------------------------------------------------------------
      ## New variables
      ##------------------------------------------------------------------------
      $self->{DATE}      = ${$param}{DATE};
   }

   return $self;
}

##******************************************************************************
## Method newNetworkNode  protected
##******************************************************************************
sub newNetworkNode
{
   my ($self,$node,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Report::NetworkNode( $node, $systemsDeclaration );
}

##******************************************************************************
## Method newSystemLeaf  protected
##******************************************************************************
sub newSystemLeaf
{
   my ($self,$node,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Report::SystemLeaf( $node, $systemsDeclaration );
}

##******************************************************************************
## Method newUserNode  protected
##******************************************************************************
sub newUserNode
{
   my ($self,$node,$systemsDeclaration) = @_;
##    return new LogTrend::Visu::Report::UserNode( $node, $systemsDeclaration ); ##
   return undef;
}

##******************************************************************************
## Method buildTree  public
##  Description  : put this object in an docbook file
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self) = @_;
   my $result = "";

   $result .= "<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\" [\n";
   $result .= "<!ENTITY % entities  SYSTEM \"global.ent\" >\n";
   $result .= "%entities;\n";
   $result .= "]>\n";
   $result .= "<book lang=\"en\">\n";
   $result .= "\n";
   $result .= "  <title>$self->{NAME}</title>\n";
   $result .= "  <subtitle>$self->{REFERENCE}</subtitle>\n"
      if(defined($self->{REFERENCE}));

   $result .= "  <bookinfo>\n";
   my $contact = $self->{CONTACT};
   foreach my $var (@$contact)
   {
      $result .= "    <author>\n";
      $result .= "      <firstname>".$var->{FIRSTNAME}."</firstname>\n";
      $result .= "      <surname>".$var->{SURNAME}."</surname>\n";
      $result .= "      <authorblurb><para><email>";
      $result .= $var->{EMAIL};
      $result .= "</email></para></authorblurb>\n";
      $result .= "    </author>\n";
   }

   if( defined($self->{DATE}) )
   {
      $result .= "    <date>$self->{DATE}</date>\n";
   }
   else
   {
      use locale;
      $result .= "    <date>" . strftime('%c', localtime()) . "</date>\n";
   }
   $result .= "\n";
   $result .= "    <![ %output.print; [\n";
   $result .= "    <graphic fileref=\"logo_logtrend.eps\" depth=\"2cm\" align=\"center\"></graphic>\n";
   $result .= "    ]]>\n";
   $result .= "  </bookinfo>\n";

   my $architectureNode = $self->{ARCHITECTURENODE};
   foreach my $var (sort keys %$architectureNode)
   {
      $result .= $architectureNode->{$var}->buildTree("");
   }

   $result .= "</book>\n";
   $result .= "\n";

   return $result;
}

##******************************************************************************
1;
